/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.util;

import com.neep.neepbus.block.NeepBusProvider;
import com.neep.neepbus.util.NeepBusPort;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.transport.api.pipe.DataCable;
import com.neep.neepmeat.util.BFSGroupFinder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class MultiCachingSender {
    private final Supplier<class_1937> world;
    private final class_2338 pos;
    private final Predicate<String> addressPredicate;
    @Nullable
    private Map<String, Set<WritePort>> portCache;

    public MultiCachingSender(Supplier<class_1937> world, class_2338 pos, Predicate<String> addressPredicate) {
        this.world = world;
        this.pos = pos;
        this.addressPredicate = addressPredicate;
    }

    public void send(String address, DataVariant data) {
        Set<WritePort> ports;
        if (this.portCache == null) {
            Finder finder = new Finder(false);
            finder.queueBlock(this.pos);
            finder.loop(200);
            this.portCache = finder.result;
        }
        if ((ports = this.portCache.get(address)) != null) {
            for (WritePort port : this.portCache.get(address)) {
                port.write(data);
            }
        }
    }

    public void invalidate() {
        this.portCache = null;
    }

    private class Finder<T extends NeepBusPort>
    extends BFSGroupFinder<T> {
        private final boolean read;
        private final Map<String, Set<T>> result = new HashMap<String, Set<T>>();
        private boolean isOrigin;

        public Finder(boolean read) {
            this.read = read;
        }

        protected void addResult(String address, T port) {
            this.result.computeIfAbsent(address, s -> new HashSet()).add(port);
        }

        @Override
        protected BFSGroupFinder.State processPos(class_2338 pos) {
            class_1937 world = MultiCachingSender.this.world.get();
            class_2680 currentState = world.method_8320(pos);
            class_2338.class_2339 mutable = pos.method_25503();
            for (class_2350 direction : class_2350.values()) {
                class_2680 offsetState;
                DataCable dataCable;
                class_2248 class_22482;
                mutable.method_25505((class_2382)pos, direction);
                if (this.visited.contains(mutable.method_10063()) || !((class_22482 = currentState.method_26204()) instanceof DataCable) || !(dataCable = (DataCable)class_22482).isConnected(world, pos, currentState, direction, this.isOrigin) || (offsetState = world.method_8320((class_2338)mutable)).method_26215()) continue;
                boolean checkAdjacent = dataCable.checkAdjacentConnection();
                Object object = offsetState.method_26204();
                if (object instanceof DataCable) {
                    DataCable offset = (DataCable)object;
                    if (!checkAdjacent || offset.isConnected(world, (class_2338)mutable, offsetState, direction.method_10153(), false)) {
                        this.queueBlock(mutable.method_10062());
                    }
                }
                if (!((object = offsetState.method_26204()) instanceof NeepBusProvider)) continue;
                NeepBusProvider provider = (NeepBusProvider)object;
                if (this.read) {
                    for (Map.Entry entry : provider.getPorts(world, (class_2338)mutable, offsetState, null).readMap().entrySet()) {
                        if (!MultiCachingSender.this.addressPredicate.test((String)entry.getKey())) continue;
                        this.addResult((String)entry.getKey(), (NeepBusPort)entry.getValue());
                    }
                    continue;
                }
                for (Map.Entry entry : provider.getPorts(world, (class_2338)mutable, offsetState, null).writeMap().entrySet()) {
                    if (!MultiCachingSender.this.addressPredicate.test((String)entry.getKey())) continue;
                    this.addResult((String)entry.getKey(), (NeepBusPort)entry.getValue());
                }
            }
            this.isOrigin = false;
            return BFSGroupFinder.State.CONTINUE;
        }
    }
}

