/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.block.FlameJetBlock;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.transport.block.fluid_transport.machine.TankBlockEntity;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3612;
import net.minecraft.class_5575;
import net.minecraft.class_5819;

public class FlameJetBlockEntity
extends SyncableBlockEntity {
    public static final long BURN_AMOUNT = 81L;
    WritableSingleFluidStorage storage = new WritableSingleFluidStorage(324000L, this::sync){

        protected boolean canInsert(FluidVariant variant) {
            return variant.isOf((Object)class_3612.field_15908);
        }
    };
    protected boolean powered;

    public FlameJetBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public FlameJetBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.FLAME_JET, pos, state);
    }

    public Storage<FluidVariant> getFluidStorage(class_2350 direction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)FlameJetBlock.field_10927);
        return direction != facing ? this.storage : null;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10556("powered", this.powered);
        this.storage.toNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.powered = nbt.method_10577("powered");
        this.storage.readNbt(nbt);
    }

    public void setPowered(boolean powered) {
        this.powered = powered;
        this.sync();
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean canBurn() {
        return this.powered && ((FluidVariant)this.storage.getResource()).isOf((Object)class_3612.field_15908) && this.storage.getAmount() >= 81L;
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, FlameJetBlockEntity be) {
        if (((Boolean)state.method_11654((class_2769)FlameJetBlock.RUNNING)).booleanValue() != be.canBurn()) {
            world.method_8652(pos, (class_2680)state.method_28493((class_2769)FlameJetBlock.RUNNING), 2);
        }
        if (be.canBurn()) {
            class_2350 facing = (class_2350)be.method_11010().method_11654((class_2769)FlameJetBlock.field_10927);
            try (Transaction transaction = Transaction.openOuter();){
                be.storage.extract((TransferVariant)((FluidVariant)be.storage.getResource()), 81L, (TransactionContext)transaction);
                transaction.commit();
                class_238 box = new class_238(pos).method_1009((double)(facing.method_10148() * 6), (double)(facing.method_10164() * 6), (double)(facing.method_10165() * 6));
                List entityList = world.method_18023(class_5575.method_31795(class_1309.class), box, e -> true);
                entityList.forEach(entity -> {
                    entity.method_20803(10);
                    entity.method_5643(world.method_48963().method_48813(), 1.5f);
                });
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 blockState, FlameJetBlockEntity be) {
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)FlameJetBlock.field_10927);
        class_5819 random = world.method_8409();
        if (be.canBurn()) {
            for (int i = 0; i < 3; ++i) {
                world.method_8406((class_2394)class_2398.field_11240, (double)pos.method_10263() + 0.5 + ((double)random.method_43057() - 0.5) / 2.0, (double)pos.method_10264() + 0.5 + ((double)random.method_43057() - 0.5) / 2.0, (double)pos.method_10260() + 0.5 + ((double)random.method_43057() - 0.5) / 2.0, (double)((float)facing.method_10148() / 2.0f), (double)((float)facing.method_10164() / 2.0f), (double)((float)facing.method_10165() / 2.0f));
            }
        }
    }

    public boolean onUse(class_1657 player, class_1268 hand) {
        if (WritableSingleFluidStorage.handleInteract((Storage<FluidVariant>)this.storage, this.field_11863, player, hand)) {
            return true;
        }
        if (!this.field_11863.method_8608()) {
            TankBlockEntity.showContents((class_3222)player, this.field_11863, this.method_11016(), this.storage);
            return true;
        }
        return false;
    }
}

