/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.compat.emi.recipe;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.recipe.CrushingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.TextWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class GrindingEmiRecipe
implements EmiRecipe {
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final EmiRecipeCategory category;
    private final CrushingRecipe recipe;

    public GrindingEmiRecipe(EmiRecipeCategory category, CrushingRecipe recipe) {
        this.category = category;
        this.recipe = recipe;
        this.id = recipe.method_8114();
        this.input = List.of(EmiIngredient.of(recipe.getItemInput().getAll().stream().map(xva$0 -> class_1856.method_8091((class_1935[])new class_1935[]{xva$0})).map(EmiIngredient::of).toList(), (long)recipe.getItemInput().amount()));
        ArrayList<EmiStack> output = new ArrayList<EmiStack>();
        if (!recipe.destroy()) {
            output.add(EmiStack.of((class_1935)((class_1935)recipe.getItemOutput().resource()), (long)recipe.getItemOutput().minAmount()));
            if (recipe.getAuxOutput() != null) {
                output.add(EmiStack.of((class_1935)((class_1935)recipe.getAuxOutput().resource()), (long)recipe.getAuxOutput().minAmount()).setChance(recipe.getAuxOutput().chance()));
            }
        }
        this.output = output;
    }

    public EmiRecipeCategory getCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 150;
    }

    public int getDisplayHeight() {
        return 55;
    }

    public void addWidgets(WidgetHolder widgets) {
        if (this.recipe.destroy()) {
            return;
        }
        int startX = this.getDisplayWidth() / 2 - 41;
        int startY = 10;
        widgets.addText((class_2561)NeepMeat.translationKey("category", "general.energy", PowerUtils.energyForRecipe(this.recipe.getTime())), this.getDisplayWidth() - 5, 3, -12566464, false).horizontalAlign(TextWidget.Alignment.END);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, startX + 25, startY + 9);
        widgets.addSlot(this.input.get(0), startX + 1, startY + 9);
        widgets.addSlot((EmiIngredient)this.output.get(0), startX + 61, startY + 9).appendTooltip(NMrecipeTypes.ofMinMax(this.recipe.getItemOutput().minAmount(), this.recipe.getItemOutput().maxAmount())).recipeContext((EmiRecipe)this);
        if (this.output.size() > 1) {
            widgets.addSlot((EmiIngredient)this.output.get(1), startX + 81, startY + 9).recipeContext((EmiRecipe)this);
        }
    }
}

