/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.config;

import folk.sisby.kaleido.api.ReflectiveConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.ReflectiveConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.SerializedName;
import folk.sisby.kaleido.lib.quiltconfig.api.values.TrackedValue;
import folk.sisby.kaleido.lib.quiltconfig.impl.Comments;

public class NMConfig
extends ReflectiveConfig {
    @SerializedName(value="ore_fat")
    public final OreFat oreFat = new OreFat();
    @SerializedName(value="motors")
    public final Motors motors = new Motors();
    @SerializedName(value="large_compressor")
    public final LargeCompressor largeCompressor = new LargeCompressor();
    @SerializedName(value="charnel_pump")
    public final CharnelPump charnelPump = new CharnelPump();
    @SerializedName(value="pylon")
    public final Pylon pylon = new Pylon();
    @SerializedName(value="feeding_trough")
    public final FeedingTrough feedingTrough = new FeedingTrough();
    @SerializedName(value="verrucous_stone")
    public final VerrucousStone verrucousStone = new VerrucousStone();
    @SerializedName(value="living_machines")
    public final LivingMachines livingMachines = new LivingMachines();
    @SerializedName(value="power_flower")
    public final PowerFlower powerFlower = new PowerFlower();
    @Comments(value={@Comment(value={"If true, the Meatgun's ammo counter will be rendered on the item model instead of in the hud."}), @Comment(value={"Set to false if transparency issues occur."})})
    public final TrackedValue<Boolean> meatgunAmmoOnModel = this.value(true);

    public static final class OreFat
    extends ReflectiveConfig.Section {
        @Comment(value={"Rendering ore fat yield when not overridden in JSON"})
        public final TrackedValue<Float> defaultRenderingYield = this.value(Float.valueOf(1.333f));
        @Comment(value={"Trommel ore fat yield when not overridden in JSON"})
        public final TrackedValue<Float> defaultTrommelYield = this.value(Float.valueOf(1.5f));
    }

    public static final class Motors
    extends ReflectiveConfig.Section {
        @Comment(value={"Maximum power that can be transferred by a basic motor (eJ/t)"})
        public final TrackedValue<Integer> basicMotorMaxPower = this.value(400);
        @Comment(value={"Maximum power that can be transferred by an advanced motor (eJ/t)"})
        public final TrackedValue<Integer> advancedMotorMaxPower = this.value(800);
        @Comment(value={"Maximum power that can be transferred by a large motor (eJ/t)"})
        public final TrackedValue<Integer> largeMotorMaxPower = this.value(2000);
    }

    public static final class LargeCompressor
    extends ReflectiveConfig.Section {
        @Comment(value={"Droplets per unit energy per tick (droplets/eJ/t)"})
        public final TrackedValue<Integer> powerToDroplets = this.value(400);
    }

    public static final class CharnelPump
    extends ReflectiveConfig.Section {
        @Comment(value={"Minimum power required to run (eJ/t)"})
        public final TrackedValue<Integer> minPower = this.value(500);
        @Comment(value={"Air consumed per unit energy (droplets/eJ/t)"})
        public final TrackedValue<Integer> powerToAir = this.value(100);
    }

    public static final class Pylon
    extends ReflectiveConfig.Section {
        @Comment(value={"Maximum angular speed of the Pylon (???)"})
        public final TrackedValue<Float> maxSpeed = this.value(Float.valueOf(40.0f));
        @Comment(value={"Angular speed at which the Pylon begins working (???)"})
        public final TrackedValue<Float> runningSpeed = this.value(Float.valueOf(16.0f));
    }

    public static final class FeedingTrough
    extends ReflectiveConfig.Section {
        @Comment(value={"Amount of feed used to breed two animals (droplets)"})
        public final TrackedValue<Long> useAmount = this.value(13500L);
        @Comment(value={"Amount of animal feed added per gland potato (droplets)"})
        public final TrackedValue<Long> feedPerItem = this.value((Long)this.useAmount.getDefaultValue() / 2L);
    }

    public static final class VerrucousStone
    extends ReflectiveConfig.Section {
        @Comment(value={"Energy generated per Verrucous Stone block per tick (eJ/t)"})
        public final TrackedValue<Integer> passiveCoefficient = this.value(10);
    }

    public static final class LivingMachines
    extends ReflectiveConfig.Section {
        @Comment(value={"Maximum number of blocks that can be part of a single living machine"})
        public final TrackedValue<Integer> maxBlocks = this.value(128);
    }

    public static final class PowerFlower
    extends ReflectiveConfig.Section {
        @Comment(value={"Energy generated per Power Flower surface block per tick (eJ/t)"})
        public final TrackedValue<Integer> solarCoefficient = this.value(10);
        @Comment(value={"Maximum number of blocks that can be part of a single Power Flower"})
        public final TrackedValue<Integer> maxBlocks = this.value(160);
    }
}

