/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.item;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.item.BaseItem;
import com.neep.meatlib.item.TooltipSupplier;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.neepmeat.client.sound.LoopingEntityTrackingSoundInstance;
import com.neep.neepmeat.datagen.tag.NMTags;
import com.neep.neepmeat.enlightenment.EnlightenmentManager;
import com.neep.neepmeat.enlightenment.PlayerEnlightenmentManager;
import com.neep.neepmeat.init.NMComponents;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.init.NMSounds;
import java.text.DecimalFormat;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class DosimeterItem
extends BaseItem {
    public DosimeterItem(RegistrationContext registryName, TooltipSupplier tooltipSupplier, class_1792.class_1793 settings) {
        super(tooltipSupplier, settings);
    }

    @Environment(value=EnvType.CLIENT)
    public static class Client {
        private static final DecimalFormat DF = new DecimalFormat("###.#");
        @Nullable
        private static class_1113 alarmSound;

        public static void init() {
            HudRenderCallback.EVENT.register(Client::renderOverlay);
        }

        public static void onTick(class_310 client, class_1657 player, PlayerEnlightenmentManager manager) {
            boolean danger;
            boolean hasDosimeter = player.field_7514.method_7382(NMTags.DOSIMETER);
            boolean bl = danger = manager.lastDose() > 1.0;
            if (hasDosimeter && danger) {
                if (alarmSound == null) {
                    alarmSound = new LoopingEntityTrackingSoundInstance(NMSounds.DOSIMETER_ALARM, class_3419.field_15248, 0.5f, 1.0f, (class_1297)client.field_1724, 0L);
                    client.method_1483().method_4873(alarmSound);
                }
            } else if (alarmSound != null) {
                client.method_1483().method_4870(alarmSound);
                alarmSound = null;
            }
        }

        private static void renderOverlay(class_332 matrices, float tickDelta) {
            class_310 client = class_310.method_1551();
            class_1799 stack = null;
            if (client.field_1724.method_6047().method_31574(NMItems.DOSIMETER)) {
                stack = client.field_1724.method_6047();
            } else if (client.field_1724.method_6079().method_31574(NMItems.DOSIMETER)) {
                stack = client.field_1724.method_6079();
            }
            if (stack != null) {
                EnlightenmentManager manager = (EnlightenmentManager)NMComponents.ENLIGHTENMENT_MANAGER.get((Object)client.field_1724);
                int width = client.method_22683().method_4486();
                int height = client.method_22683().method_4502();
                class_5250 text = class_2561.method_30163((String)("Dose per tick: " + DF.format(manager.lastDose()))).method_27661().method_27692(class_124.field_1054);
                int textWidth = client.field_1772.method_27525((class_5348)text);
                GUIUtil.drawText(matrices, client.field_1772, (class_2561)text, (float)(width - textWidth) / 2.0f, (float)(height - 50), -1, true);
            }
        }
    }
}

