/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.fabricator;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.fabricator.FabricatorBlockEntity;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;

public class FabricatorInstance
extends BlockEntityInstance<FabricatorBlockEntity>
implements DynamicInstance {
    private final ModelData rotor;
    private final List<ModelData> segments;
    private float speed;
    private float mainAngle;
    private final class_310 client = class_310.method_1551();

    public FabricatorInstance(MaterialManager materialManager, FabricatorBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.rotor = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.FABRICATOR_ROTOR).createInstance();
        this.segments = IntStream.range(0, 8).mapToObj(i -> (ModelData)materialManager.defaultCutout().material(Materials.TRANSFORMED).getModel(NMExtraModels.FABRICATOR_SEGMENT).createInstance()).toList();
    }

    protected void remove() {
        this.rotor.delete();
        for (ModelData segment : this.segments) {
            segment.delete();
        }
    }

    public void beginFrame() {
        boolean paused = this.client.method_1493();
        this.speed = class_3532.method_16439((float)(paused ? 0.0f : 0.1f), (float)this.speed, (float)(((FabricatorBlockEntity)this.blockEntity).animation ? 10.0f : 0.0f));
        if (((FabricatorBlockEntity)this.blockEntity).animation) {
            ((FabricatorBlockEntity)this.blockEntity).animation = false;
        }
        this.mainAngle += paused ? 0.0f : this.client.method_1534() * this.speed;
        ((ModelData)this.rotor.loadIdentity().translate((class_2382)this.getInstancePosition())).translate(0.0, 1.0, 0.0).rotateCentered(class_2350.field_11036, this.mainAngle);
        for (int i = 0; i < this.segments.size(); ++i) {
            float angle = (float)Math.PI / 180 * ((float)i / 8.0f * 360.0f % 360.0f) + this.mainAngle;
            float yOffset = 0.1f * class_3532.method_15374((float)(this.mainAngle * ((float)i - 8.0f * class_3532.method_15374((float)(this.mainAngle / 100.0f)) - 4.0f)));
            ((ModelData)this.segments.get(i).loadIdentity().translate((class_2382)this.getInstancePosition())).translate(0.0, (double)(1.0f - yOffset), 0.0).rotateCentered(class_2350.field_11036, angle);
        }
    }

    public void updateLight() {
        this.relight(this.getWorldPosition(), this.segments.stream());
        this.relight(this.getWorldPosition(), new FlatLit[]{this.rotor});
    }

    public static void initNetwork() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)FabricatorBlockEntity.CHANNEL_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            client.execute(() -> {
                class_2586 patt3711$temp = client.field_1687.method_8321(pos);
                if (patt3711$temp instanceof FabricatorBlockEntity) {
                    FabricatorBlockEntity fabricator = (FabricatorBlockEntity)patt3711$temp;
                    fabricator.animation = true;
                }
            });
        });
    }
}

