/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.grinder;

import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.block.entity.MotorisedMachineBlockEntity;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.grinder.GrinderBlock;
import com.neep.neepmeat.machine.grinder.GrinderStorage;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.recipe.CrushingRecipe;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1303;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public class GrinderBlockEntity
extends MotorisedMachineBlockEntity {
    protected Random jrandom = new Random();
    protected GrinderStorage storage = new GrinderStorage(this);
    protected int cooldownTicks = 2;
    protected int processLength;
    protected float progress;
    protected class_2960 currentRecipeId;
    protected CrushingRecipe lastRecipe;
    protected CrushingRecipe currentRecipe;

    public GrinderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, 0.02f, 0.02f, 2.0f);
    }

    public GrinderBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.CRUSHER, pos, state);
    }

    public CrushingRecipe getCurrentRecipe() {
        return this.currentRecipe;
    }

    public void setCurrentRecipe(@Nullable CrushingRecipe recipe) {
        this.currentRecipe = recipe;
        this.currentRecipeId = recipe != null ? recipe.method_8114() : null;
    }

    public void readCurrentRecipe() {
        if (this.field_11863 != null) {
            Optional<MeatlibRecipe<?>> optional = MeatlibRecipes.getInstance().get(this.currentRecipeId);
            optional.ifPresentOrElse(recipe -> {
                this.currentRecipe = (CrushingRecipe)recipe;
            }, () -> {
                this.currentRecipe = null;
            });
        }
    }

    public GrinderStorage getStorage() {
        return this.storage;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10548("power", this.power);
        nbt.method_10548("progress", this.progress);
        nbt.method_10569("process_length", this.processLength);
        nbt.method_10548("progress_increment", this.progressIncrement);
        if (this.currentRecipe != null) {
            nbt.method_10582("current_recipe", this.currentRecipe.method_8114().toString());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.power = nbt.method_10583("power");
        this.progress = nbt.method_10583("progress");
        this.processLength = nbt.method_10550("process_length");
        this.currentRecipeId = new class_2960(nbt.method_10558("current_recipe"));
        this.progressIncrement = nbt.method_10583("progress_increment");
        this.readCurrentRecipe();
    }

    @Override
    public void method_5431() {
        super.method_5431();
        this.field_11863.method_8455(this.field_11867, this.method_11010().method_26204());
    }

    public void tick() {
        this.readCurrentRecipe();
        if (!this.storage.outputStorage.isEmpty() || !this.storage.extraStorage.isEmpty()) {
            try (Transaction transaction = Transaction.openOuter();){
                this.ejectOutput((TransactionContext)transaction);
                transaction.commit();
            }
        }
        if (this.currentRecipe != null) {
            this.progress = Math.min((float)this.processLength, this.progress + this.progressIncrement);
            if (this.progress >= (float)this.processLength || !this.getCurrentRecipe().matches(this.storage)) {
                this.endRecipe();
                this.progress = 0.0f;
            }
        } else {
            this.progress += 1.0f;
            if (this.progress >= (float)this.cooldownTicks) {
                this.startRecipe();
                this.progress = 0.0f;
            }
        }
        super.serverTick();
    }

    private void startRecipe() {
        if (this.currentRecipe == null && this.storage.outputStorage.isEmpty() && !this.storage.inputStorage.isEmpty()) {
            CrushingRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.GRINDING, this.storage).orElse(null);
            try (Transaction transaction = Transaction.openOuter();){
                if (recipe != null && recipe.ejectOutputs(this.storage, (TransactionContext)transaction)) {
                    this.setCurrentRecipe(recipe);
                    this.processLength = recipe.getTime();
                    this.sync();
                }
                transaction.abort();
            }
        }
    }

    private void endRecipe() {
        if (this.currentRecipe != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.getCurrentRecipe().matches(this.storage) && this.getCurrentRecipe().ejectOutputs(this.storage, (TransactionContext)transaction) && this.getCurrentRecipe().takeInputs(this.storage, (TransactionContext)transaction)) {
                    this.ejectOutput((TransactionContext)transaction);
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
            this.setCurrentRecipe(null);
        }
        this.sync();
    }

    protected void ejectOutput(TransactionContext transaction) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)GrinderBlock.field_11177);
        CombinedStorage combined = new CombinedStorage(List.of(this.storage.outputStorage, this.storage.extraStorage));
        ItemPipeUtil.storageToAny((class_3218)this.method_10997(), (Storage<ItemVariant>)combined, this.field_11867, facing, transaction);
    }

    protected void ejectXP() {
        try (Transaction transaction = Transaction.openOuter();){
            class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)GrinderBlock.field_11177);
            class_243 xpPos = class_243.method_26410((class_2382)this.field_11867, (double)0.5).method_1031((double)facing.method_10148() * 0.6, (double)facing.method_10164() * 0.6, (double)facing.method_10165() * 0.6);
            class_1303.method_31493((class_3218)((class_3218)this.field_11863), (class_243)xpPos, (int)((int)Math.ceil(this.storage.getXpStorage().getAmount())));
            this.storage.xpStorage.extract(Float.MAX_VALUE, (TransactionContext)transaction);
            transaction.commit();
        }
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        this.tick();
        return this.currentRecipe != null;
    }

    @Override
    public float getLoadTorque() {
        return 400.0f;
    }

    public void clientTick() {
        float intensity = this.progressIncrement / this.maxIncrement;
        int tickInterval = (int)class_3532.method_15363((float)1.0f, (float)(1.0f / (intensity * 2.0f)), (float)100.0f);
        if (this.field_11863.method_8510() % (long)tickInterval == 0L && this.currentRecipe != null && !this.storage.inputStorage.isEmpty() && this.progressIncrement > 0.0f) {
            double px = (double)this.method_11016().method_10263() + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 0.5;
            double py = (double)this.method_11016().method_10264() + 0.8 + ((double)this.jrandom.nextFloat() - 0.5) * 0.5;
            double pz = (double)this.method_11016().method_10260() + 0.5 + ((double)this.jrandom.nextFloat() - 0.5) * 0.5;
            double vx = ((double)this.jrandom.nextFloat() - 0.5) * 0.2;
            double vy = (double)this.jrandom.nextFloat() * Math.max(0.3, 0.5 * (double)intensity);
            double vz = ((double)this.jrandom.nextFloat() - 0.5) * 0.2;
            this.field_11863.method_8406((class_2394)new class_2392(class_2398.field_11218, this.storage.inputStorage.getAsStack()), px, py, pz, vx, vy, vz);
        }
    }
}

