/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.component.PoweredComponent;
import com.neep.neepmeat.machine.small_trommel.TrommelRecipe;
import com.neep.neepmeat.machine.small_trommel.TrommelStorage;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LargeTrommelBlockEntity
extends SyncableBlockEntity
implements LivingMachineComponent,
PoweredComponent {
    private float progressIncrement;
    private final InputSlot inputSlot = new InputSlot(9000L, this::sync, () -> ((LargeTrommelBlockEntity)this).method_10997());

    public LargeTrommelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10548("progress_increment", this.progressIncrement);
        this.inputSlot.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.progressIncrement = nbt.method_10583("progress_increment");
        this.inputSlot.readNbt(nbt);
    }

    @Override
    public boolean componentRemoved() {
        return this.method_11015();
    }

    public InputSlot getStorage() {
        return this.inputSlot;
    }

    @Override
    public ComponentType<? extends LivingMachineComponent> getComponentType() {
        return LivingMachineComponents.LARGE_TROMMEL;
    }

    @Override
    public float progressIncrement() {
        return this.progressIncrement;
    }

    @Override
    public void setProgressIncrement(float progressIncrement) {
        if (progressIncrement != this.progressIncrement) {
            this.progressIncrement = progressIncrement;
            this.sync();
        }
    }

    public static class InputSlot
    extends WritableSingleFluidStorage
    implements StorageView<FluidVariant> {
        private final Supplier<class_1937> worldGetter;
        @Nullable
        private TrommelRecipe recipe;
        private float progress;
        public final float totalProgress = 30.0f;
        public long recipeStartTime;

        public InputSlot(long capacity, Runnable finalCallback, Supplier<class_1937> worldGetter) {
            super(capacity, finalCallback);
            this.worldGetter = worldGetter;
        }

        public void tick(float progressIncrement, Storage<FluidVariant> output, Storage<ItemVariant> itemOutput, TransactionContext transaction) {
            if (this.recipe != null) {
                this.progress += progressIncrement;
                if (this.progress >= 30.0f) {
                    StorageWrapper wrapper = new StorageWrapper(this, output, itemOutput);
                    if (this.recipe.takeInputs(wrapper, transaction)) {
                        this.recipe.ejectOutputs(wrapper, transaction);
                    }
                    this.recipe = null;
                    this.progress = 0.0f;
                }
            } else {
                StorageWrapper wrapper = new StorageWrapper(this, output, itemOutput);
                this.recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.TROMMEL, wrapper).orElse(null);
                if (this.recipe == null) {
                    this.recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.FAT_TROMMEL, wrapper).orElse(null);
                }
                if (this.recipe != null) {
                    this.recipeStartTime = this.worldGetter.get().method_8510();
                }
            }
        }

        @Override
        public void writeNbt(class_2487 nbt) {
            super.writeNbt(nbt);
            nbt.method_10544("recipe_start_time", this.recipeStartTime);
            nbt.method_10548("progress", this.progress);
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
        }

        @Override
        public class_2487 readNbt(class_2487 nbt) {
            super.readNbt(nbt);
            this.recipeStartTime = nbt.method_10537("recipe_start_time");
            this.progress = nbt.method_10583("progress");
            this.recipe = nbt.method_10545("recipe") ? (TrommelRecipe)MeatlibRecipes.getInstance().get(class_2960.method_12829((String)nbt.method_10558("recipe"))).orElse(null) : null;
            return nbt;
        }
    }

    private record StorageWrapper(SingleVariantStorage<FluidVariant> input, Storage<FluidVariant> output, Storage<ItemVariant> itemOutput) implements TrommelStorage
    {
    }
}

