/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.mixer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.neep.meatlib.recipe.MeatRecipeSerialiser;
import com.neep.meatlib.recipe.MeatlibRecipe;
import com.neep.meatlib.recipe.ingredient.RecipeInputs;
import com.neep.meatlib.recipe.ingredient.RecipeOutput;
import com.neep.meatlib.recipe.ingredient.RecipeOutputImpl;
import com.neep.meatlib.recipe.ingredient.RecipeOutputs;
import com.neep.meatlib.recipe.ingredient.RegistryRecipeInput;
import com.neep.meatlib.util.MeatLibCodecs;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.mixer.MixerStorage;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

public class MixingRecipe
implements MeatlibRecipe<MixerStorage> {
    protected class_2960 id;
    protected RegistryRecipeInput<class_1792> itemInput;
    protected RegistryRecipeInput<class_3611> fluidInput1;
    protected RegistryRecipeInput<class_3611> fluidInput2;
    protected RecipeOutput<class_3611> fluidOutput;
    protected int processTime;

    public MixingRecipe(class_2960 id, RegistryRecipeInput<class_1792> itemInput, RegistryRecipeInput<class_3611> fluidInput1, RegistryRecipeInput<class_3611> fluidInput2, RecipeOutput<class_3611> fluidOutput, int processTime) {
        this.itemInput = itemInput;
        this.fluidInput1 = fluidInput1;
        this.fluidInput2 = fluidInput2;
        this.fluidOutput = fluidOutput;
        this.processTime = processTime;
        this.id = id;
    }

    public RegistryRecipeInput<class_1792> getItemIngredient() {
        return this.itemInput;
    }

    public List<RegistryRecipeInput<class_3611>> getFluidInputs() {
        return List.of(this.fluidInput1, this.fluidInput2);
    }

    public RecipeOutput<class_3611> getFluidOutput() {
        return this.fluidOutput;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    @Override
    public boolean matches(MixerStorage inventory) {
        Transaction transaction = Transaction.openOuter();
        LinkedList<RegistryRecipeInput<class_3611>> queue = new LinkedList<RegistryRecipeInput<class_3611>>(List.of(this.fluidInput1, this.fluidInput2));
        ListIterator it = queue.listIterator();
        Storage<FluidVariant> parentStorages = inventory.getInputStorages();
        block0: while (it.hasNext()) {
            RegistryRecipeInput ingredient = (RegistryRecipeInput)it.next();
            if (ingredient.isEmpty()) {
                it.remove();
                continue;
            }
            for (StorageView view : parentStorages) {
                if (!ingredient.test(view)) continue;
                it.remove();
                continue block0;
            }
        }
        transaction.abort();
        return queue.isEmpty() && this.itemInput.test(inventory.getItemInput());
    }

    @Override
    public boolean takeInputs(MixerStorage inventory, TransactionContext transactionContext) {
        try (Transaction inner = transactionContext.openNested();){
            List<Storage<FluidVariant>> inputList = inventory.parent.getAdjacentStorages();
            Storage<FluidVariant> fluidStorage = inventory.getInputStorages();
            if (!inputList.isEmpty()) {
                long ext3;
                class_3611 fluid1 = this.fluidInput1.isEmpty() ? class_3612.field_15906 : this.fluidInput1.getFirstMatching(fluidStorage, transactionContext).orElseThrow(() -> new IllegalStateException("Storage contents must conform to recipe"));
                class_3611 fluid2 = this.fluidInput2.isEmpty() ? class_3612.field_15906 : this.fluidInput2.getFirstMatching(fluidStorage, transactionContext).orElseThrow(() -> new IllegalStateException("Storage contents must conform to recipe"));
                class_1792 item = this.itemInput.isEmpty() ? class_1802.field_8831 : this.itemInput.getFirstMatching(inventory.getItemInput()).orElseThrow(() -> new IllegalStateException("Storage contents must conform to recipe"));
                FluidVariant variant1 = FluidVariant.of((class_3611)fluid1);
                FluidVariant variant2 = FluidVariant.of((class_3611)fluid2);
                long ext1 = fluidStorage.extract((Object)variant1, this.fluidInput1.amount(), (TransactionContext)inner);
                long ext2 = variant2.isBlank() ? this.fluidInput2.amount() : fluidStorage.extract((Object)variant2, this.fluidInput2.amount(), (TransactionContext)inner);
                long l = ext3 = this.itemInput.isEmpty() ? this.itemInput.amount() : inventory.getItemInput().extract((TransferVariant)ItemVariant.of((class_1935)item), this.itemInput.amount(), (TransactionContext)inner);
                if (ext1 == this.fluidInput1.amount() && ext2 == this.fluidInput2.amount() && ext3 == this.itemInput.amount()) {
                    inner.commit();
                    inventory.displayInput1 = variant1;
                    inventory.displayInput2 = variant2;
                    boolean bl = true;
                    return bl;
                }
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public boolean ejectOutputs(MixerStorage inventory, TransactionContext transaction) {
        try (Transaction inner = transaction.openNested();){
            Storage<FluidVariant> output = inventory.getFluidOutput();
            if (this.fluidOutput.insertInto(output, FluidVariant::of, transaction)) {
                inner.commit();
                boolean bl = true;
                return bl;
            }
            inner.abort();
        }
        return false;
    }

    @Override
    public class_2960 method_8114() {
        return this.id;
    }

    @Override
    public MeatRecipeSerialiser<?> getSerializer() {
        return NMrecipeTypes.MIXING_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return NMrecipeTypes.MIXING;
    }

    public static class MixerSerializer
    implements MeatRecipeSerialiser<MixingRecipe> {
        private final Codec<MeatRecipeSerialiser.RecipeFunction<MixingRecipe>> codec = RecordCodecBuilder.create(instance -> instance.group((App)RecipeInputs.ITEM.codec().fieldOf("item").forGetter(MeatLibCodecs::notImplemented), (App)RecipeInputs.FLUID.codec().fieldOf("fluid1").forGetter(MeatLibCodecs::notImplemented), (App)RecipeInputs.FLUID.codec().fieldOf("fluid2").forGetter(MeatLibCodecs::notImplemented), (App)RecipeOutputs.FLUID.fieldOf("output").forGetter(MeatLibCodecs::notImplemented), (App)Codec.INT.fieldOf("processtime").forGetter(MeatLibCodecs::notImplemented)).apply((Applicative)instance, (i, f1, f2, o, t) -> id -> new MixingRecipe(id, (RegistryRecipeInput<class_1792>)i, (RegistryRecipeInput<class_3611>)f1, (RegistryRecipeInput<class_3611>)f2, (RecipeOutput<class_3611>)o, (int)t)));

        @Override
        public Codec<MeatRecipeSerialiser.RecipeFunction<MixingRecipe>> codec() {
            return this.codec;
        }

        @Override
        public MixingRecipe read(class_2960 id, class_2540 buf) {
            RegistryRecipeInput<class_1792> ingredient = RegistryRecipeInput.fromBuffer(buf);
            RegistryRecipeInput<class_3611> fluidInput1 = RegistryRecipeInput.fromBuffer(buf);
            RegistryRecipeInput<class_3611> fluidInput2 = RegistryRecipeInput.fromBuffer(buf);
            RecipeOutputImpl<class_3611> fluidOutput = RecipeOutputImpl.read(class_7923.field_41173, buf);
            int time = buf.method_10816();
            return new MixingRecipe(id, ingredient, fluidInput1, fluidInput2, fluidOutput, time);
        }

        @Override
        public void write(class_2540 buf, MixingRecipe recipe) {
            recipe.itemInput.write(buf);
            recipe.fluidInput1.write(buf);
            recipe.fluidInput2.write(buf);
            recipe.fluidOutput.write(buf);
            buf.method_10804(recipe.processTime);
        }

        @FunctionalInterface
        public static interface RecipeFactory<T extends MixingRecipe> {
            public T create(class_2960 var1, RegistryRecipeInput<class_1792> var2, RegistryRecipeInput<class_3611> var3, RegistryRecipeInput<class_3611> var4, RecipeOutputImpl<class_3611> var5, int var6);
        }
    }
}

