/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.small_trommel;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.neepmeat.api.machine.MotorisedBlock;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.motor.MotorEntity;
import com.neep.neepmeat.machine.small_trommel.SmallTrommelBlock;
import com.neep.neepmeat.machine.small_trommel.SmallTrommelStorage;
import com.neep.neepmeat.machine.small_trommel.TrommelRecipe;
import com.neep.neepmeat.transport.api.AutoEjector;
import com.neep.neepmeat.transport.util.ItemPipeUtil;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class SmallTrommelBlockEntity
extends SyncableBlockEntity
implements MotorisedBlock,
MotorisedBlock.DiagnosticsProvider {
    public static final int PU_PROCESS_ENERGY = 30;
    public static final float INCREMENT_MIN = 0.1f;
    public SmallTrommelStorage storage = new SmallTrommelStorage(this);
    public FluidVariant currentFluid;
    protected int totalProgress;
    protected float progress;
    public float renderProgress;
    private float progressIncrement;
    protected Random random;
    private float power = 0.0f;
    private final float minPower = 0.02f;
    private final AutoEjector<FluidVariant> ejector;

    public SmallTrommelBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.random = new Random(pos.method_10063());
        class_2350 facing = (class_2350)state.method_11654((class_2769)SmallTrommelBlock.field_11177);
        this.ejector = AutoEjector.simpleFluid(() -> class_2350.field_11033, () -> ((SmallTrommelBlockEntity)this).method_10997(), pos.method_10093(facing), (Storage<FluidVariant>)this.storage.fluidOutput, SmallTrommelBlock.Structure.PUMP);
    }

    public SmallTrommelBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.SMALL_TROMMEL, pos, state);
    }

    public Storage<FluidVariant> getOutputFluidStorage() {
        return this.storage.fluidOutput;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.writeNbt(nbt);
        nbt.method_10548("progress", this.progress);
        nbt.method_10548("progressIncrement", this.progressIncrement);
        nbt.method_10569("totalProgress", this.totalProgress);
        if (this.currentFluid != null) {
            nbt.method_10566("currentFluid", (class_2520)this.currentFluid.toNbt());
        }
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
        this.progress = nbt.method_10583("progress");
        this.progressIncrement = nbt.method_10583("progressIncrement");
        this.totalProgress = nbt.method_10550("totalProgress");
        this.currentFluid = FluidVariant.fromNbt((class_2487)nbt.method_10562("currentFluid"));
    }

    public void convert() {
        TrommelRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.TROMMEL, this.storage).orElse(null);
        if (recipe == null) {
            recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.FAT_TROMMEL, this.storage).orElse(null);
        }
        if (recipe != null) {
            try (Transaction transaction = Transaction.openOuter();){
                if (recipe.takeInputs(this.storage, (TransactionContext)transaction) && recipe.ejectOutputs(this.storage, (TransactionContext)transaction)) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
        }
    }

    @Override
    public boolean motorTick(MotorEntity motor) {
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)SmallTrommelBlock.field_11177);
        if (!this.storage.itemOutput.isEmpty()) {
            try (Transaction transaction = Transaction.openOuter();){
                ItemPipeUtil.storageToAny((class_3218)this.field_11863, (Storage<ItemVariant>)this.storage.itemOutput(), this.field_11867.method_10093(facing), facing, (TransactionContext)transaction);
                transaction.commit();
            }
        }
        this.totalProgress = 30;
        SingleVariantStorage<FluidVariant> fluidInput = this.storage.input();
        this.currentFluid = !((FluidVariant)fluidInput.getResource()).isBlank() ? (FluidVariant)fluidInput.getResource() : null;
        this.progress = this.currentFluid != null && this.progressIncrement != 0.1f ? Math.min((float)this.totalProgress, this.progress + this.progressIncrement) : 0.0f;
        if (this.progress >= (float)this.totalProgress) {
            this.progress = 0.0f;
            this.convert();
        }
        this.softSync();
        this.ejector.tick(null);
        return false;
    }

    @Override
    public void setInputPower(float power) {
        this.power = power;
        this.progressIncrement = power >= 0.02f ? class_3532.method_16439((float)power, (float)0.1f, (float)2.0f) : 0.0f;
    }

    public Storage<ItemVariant> getOutputItemStorage() {
        return this.storage.itemOutput;
    }

    @Override
    public MotorisedBlock.Diagnostics getDiagnostics() {
        return MotorisedBlock.Diagnostics.insufficientPower(this.power < 0.02f, this.power, 0.02f);
    }

    public static class Structure
    extends class_2586 {
        public Structure(class_2591<?> type, class_2338 pos, class_2680 state) {
            super(type, pos, state);
        }

        public Structure(class_2338 pos, class_2680 state) {
            super(NMBlockEntities.SMALL_TROMMEL_STRUCTURE, pos, state);
        }
    }
}

