/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler;

import com.neep.neepmeat.api.plc.program.PLCProgram;
import com.neep.neepmeat.api.storage.WorldSupplier;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.LabelLookup;
import com.neep.neepmeat.neepasm.compiler.ParsedInstructionList;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.PlcParsedInstruction;
import com.neep.neepmeat.plc.program.PLCProgramImpl;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;

public class NeepAsmPLCCompiler {
    private final WorldSupplier world;

    public NeepAsmPLCCompiler(WorldSupplier world) {
        this.world = world;
    }

    public <T extends ParsedInstructionList & LabelLookup> PLCProgram compile(T parsedSource) throws NeepASM.ProgramBuildException {
        PLCProgramImpl program = new PLCProgramImpl(this.world.as());
        for (ObjectIntPair<ParsedInstruction> intPair : parsedSource.instructions()) {
            try {
                program.setDebugLine(intPair.valueInt());
                PlcParsedInstruction.build(this.world.get(), (ParsedInstruction)intPair.key(), parsedSource, program);
            }
            catch (NeepASM.CompilationException e) {
                throw new NeepASM.ProgramBuildException(intPair.valueInt(), 0, e.getMessage());
            }
        }
        return program;
    }
}

