/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.plc.instruction;

import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.neepbus.util.message.DataVariant;
import com.neep.neepmeat.api.plc.PLC;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.NeepAsmParser;
import com.neep.neepmeat.neepasm.compiler.parser.InstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.variable.IntVariable;
import com.neep.neepmeat.neepasm.compiler.variable.Variable;
import com.neep.neepmeat.neepasm.vm.VM;
import com.neep.neepmeat.plc.Instructions;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import com.neep.neepmeat.plc.memory.MemoryEntry;
import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record PushInstruction(DataVariant immediate, boolean pointer) implements Instruction
{
    public PushInstruction(int immediate) {
        this(immediate, false);
    }

    public PushInstruction(int immediate, boolean pointer) {
        this(DataVariant.of(immediate), pointer);
    }

    public PushInstruction(Supplier<class_1937> ignoredWorld, class_2487 nbt) {
        this(DataVariant.of(nbt.method_10558("immediate")), nbt.method_10577("pointer"));
    }

    @Override
    public void start(VM plc) throws NeepASM.RuntimeException {
        if (this.pointer && !this.immediate.isNumeric() && plc instanceof PLC) {
            PLC p = (PLC)plc;
            plc.dataStack().push(p.getMemory().allocate(MemoryEntry.of(this.immediate)), true);
        } else {
            plc.dataStack().push(this.immediate.intValue(), this.pointer);
        }
        plc.advanceCounter();
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        nbt.method_10582("immediate", this.immediate.stringValue());
        nbt.method_10556("pointer", this.pointer);
        return nbt;
    }

    @Override
    @NotNull
    public InstructionProvider getOpcode() {
        return Instructions.PUSH;
    }

    @Override
    @NotNull
    public String toString() {
        return "PushInstruction{immediate=" + String.valueOf(this.immediate) + "}";
    }

    public static class Parser
    implements InstructionParser {
        @Override
        public ParsedInstruction parse(NeepAsmTokenView view, NeepAsmParser parser, @Nullable String scope) throws NeepASM.ParseException {
            Variable<?> variable = Parser.parseImmediate(view);
            parser.assureLineEnd(view);
            return (source, program) -> new PushInstruction((Integer)variable.value());
        }

        private static Variable<?> parseImmediate(NeepAsmTokenView view) throws NeepASM.ParseException {
            view.fastForward();
            char c = view.peek();
            if (NeepAsmTokenView.isDigit(c)) {
                int i = view.nextInteger();
                return new IntVariable(i);
            }
            throw new NeepASM.ParseException("invalid immediate variable");
        }
    }
}

