/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.blood_network;

import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.neep.neepmeat.transport.api.pipe.VascularConduit;
import com.neep.neepmeat.transport.api.pipe.VascularConduitEntity;
import com.neep.neepmeat.transport.blood_network.ConduitBloodNetwork;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.HashSet;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class BloodNetGraph {
    protected final class_1937 world;
    protected final ConduitBloodNetwork.AcceptorManager acceptors;
    protected Long2ObjectOpenHashMap<VascularConduitEntity> conduits = new Long2ObjectOpenHashMap();

    public BloodNetGraph(class_1937 world, ConduitBloodNetwork.AcceptorManager acceptors) {
        this.world = world;
        this.acceptors = acceptors;
    }

    public void clear() {
        this.conduits.clear();
    }

    public Long2ObjectMap<VascularConduitEntity> getConduits() {
        return this.conduits;
    }

    public void rebuild(class_2338 startPos) {
        this.clear();
        HashSet visited = Sets.newHashSet();
        ArrayDeque posQueue = Queues.newArrayDeque();
        class_2338.class_2339 mutable = startPos.method_25503();
        posQueue.add(startPos);
        visited.add(startPos.method_10063());
        while (!posQueue.isEmpty()) {
            class_2680 currentState;
            class_2338 current = (class_2338)posQueue.poll();
            VascularConduit conduit = VascularConduit.find(this.world, current, currentState = this.world.method_8320(current));
            if (conduit == null) continue;
            this.insert(current.method_10063(), conduit.getEntity(this.world, current, currentState));
            for (class_2350 direction : class_2350.values()) {
                if (!conduit.isConnectedIn((class_1922)this.world, current, currentState, direction)) continue;
                mutable.method_25505((class_2382)current, direction);
                if (visited.contains(mutable.method_10063())) continue;
                visited.add(mutable.method_10063());
                class_2680 nextState = this.world.method_8320((class_2338)mutable);
                VascularConduit nextConduit = VascularConduit.find(this.world, (class_2338)mutable, nextState);
                if (nextConduit == null || !nextConduit.isConnectedIn((class_1922)this.world, (class_2338)mutable, nextState, direction.method_10153())) continue;
                posQueue.add(mutable.method_10062());
            }
        }
    }

    public boolean isEmpty() {
        return this.conduits.isEmpty();
    }

    public void insert(long lpos, VascularConduitEntity newPart) {
        this.conduits.put(lpos, (Object)newPart);
        class_2338 pos = class_2338.method_10092((long)lpos);
        class_2680 state = this.world.method_8320(pos);
        VascularConduit conduit = VascularConduit.find(this.world, pos, state);
        if (conduit == null) {
            return;
        }
        this.acceptors.discover(this.world, pos, state, conduit);
    }

    public void remove(long pos) {
        this.conduits.remove(pos);
    }

    public class_2487 toNbt() {
        class_2487 root = new class_2487();
        class_2499 list = new class_2499();
        this.conduits.long2ObjectEntrySet().fastForEach(entry -> list.add((Object)class_2503.method_23251((long)entry.getLongKey())));
        root.method_10566("conduits", (class_2520)list);
        return root;
    }

    public void readNbt(class_2487 nbt) {
        class_2499 list = nbt.method_10554("conduits", 4);
        for (class_2520 entry : list) {
            if (!(entry instanceof class_2503)) continue;
            class_2503 l = (class_2503)entry;
            long lpos = l.method_10699();
            class_2338 pos = class_2338.method_10092((long)lpos);
            class_2680 state = this.world.method_8320(pos);
            VascularConduitEntity entity = VascularConduitEntity.find(this.world, pos);
            if (entity == null) continue;
            this.conduits.put(lpos, (Object)entity);
        }
    }
}

