/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.transport.fluid_network;

import com.neep.neepmeat.transport.fluid_network.FluidNodeHolder;
import com.neep.neepmeat.transport.fluid_network.node.FluidNode;
import com.neep.neepmeat.transport.fluid_network.node.NodePos;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class FluidNodeHelper {
    protected final class_3218 world;

    public FluidNodeHelper(class_3218 world) {
        this.world = world;
    }

    public static FluidNodeHelper getInstance(class_3218 world) {
        return new FluidNodeHelper(world);
    }

    public static void removeStorageNodes(class_1937 world, class_2338 pos) {
        FluidNodeHolder holder = FluidNodeHolder.find(world, pos);
        if (holder != null) {
            holder.clearNodes();
        }
        for (class_2350 direction : class_2350.values()) {
            NodePos nodePos = new NodePos(pos, direction);
            FluidNodeHelper.removeNode(world, nodePos);
        }
    }

    public static boolean removeNode(class_1937 world, NodePos pos) {
        FluidNodeHolder holder = FluidNodeHolder.find(world, pos.pos());
        if (holder != null) {
            return holder.removeNode(pos.face());
        }
        return false;
    }

    public static boolean updatePosition(class_1937 world, NodePos pos) {
        Storage storage = (Storage)FluidStorage.SIDED.find(world, pos.facingBlock(), (Object)pos.face().method_10153());
        if (storage == null) {
            if (FluidNodeHelper.get(world, pos) != null) {
                FluidNodeHelper.removeNode(world, pos);
                return true;
            }
            return false;
        }
        FluidNodeHolder holder = FluidNodeHolder.find(world, pos.pos());
        if (holder != null) {
            FluidNode prevNode = holder.getNode(pos.face());
            if (prevNode == null) {
                FluidNode node = new FluidNode(pos, (class_3218)world);
                holder.putNode(pos.face(), node);
                return true;
            }
            if (prevNode.getStorage((class_3218)world) != storage) {
                prevNode.findStorage((class_3218)world);
                return false;
            }
        }
        return false;
    }

    public static FluidNode get(class_1937 world, NodePos nodePos) {
        FluidNodeHolder holder = FluidNodeHolder.find(world, nodePos.pos());
        return holder != null ? holder.getNode(nodePos.face()) : null;
    }

    public static void readNodes(FluidNodeHolder holder, class_2487 nbt, class_3218 world) {
        for (class_2350 direction : class_2350.values()) {
            class_2520 nodeNbt = nbt.method_10580(direction.toString());
            if (nodeNbt == null) continue;
            holder.putNode(direction, FluidNode.fromNbt((class_2487)nodeNbt, world));
        }
    }

    public static class_2487 writeNodes(class_1937 world, class_2338 pos, class_2487 nbt) {
        for (class_2350 direction : class_2350.values()) {
            FluidNode node = FluidNodeHelper.get(world, new NodePos(pos, direction));
            if (node == null) continue;
            class_2487 nodeNbt = new class_2487();
            nodeNbt = node.writeNbt(nodeNbt);
            nbt.method_10566(node.getNodePos().face().toString(), (class_2520)nodeNbt);
        }
        return nbt;
    }
}

