/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib;

import com.neep.meatlib.MeatLib;
import com.neep.meatlib.registry.RegistrationContext;
import com.neep.meatlib.registry.annotation.Ignore;
import com.neep.meatlib.registry.annotation.RegisterMe;
import it.unimi.dsi.fastutil.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MeatLibRegistration {
    private static final List<Pair<Class<?>, RegistrationContext>> LIST = new ArrayList();

    public static <T> void forContext(Class<T> tClass, RegistrationContext context) {
        LIST.add(Pair.of(tClass, (Object)context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Iterator<Pair<Class<?>, RegistrationContext>> it = LIST.iterator();
        while (it.hasNext()) {
            Pair<Class<?>, RegistrationContext> pair = it.next();
            Class clazz = (Class)pair.key();
            @Nullable RegisterMe annotation = clazz.getAnnotation(RegisterMe.class);
            if (annotation == null) {
                MeatLib.LOGGER.warn(String.format("Class %s is not annotated with %s", clazz, RegisterMe.class.getSimpleName()));
            }
            RegistrationContext ctx = (RegistrationContext)pair.value();
            String namespace = annotation.value();
            Arrays.stream(clazz.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers())).filter(f -> !f.isAnnotationPresent(Ignore.class)).filter(f -> ctx.isValidClass(f.getType())).forEach(f -> MeatLibRegistration.processField(namespace, ctx, f));
            try {
                ctx.registerAll();
            }
            catch (Exception e) {
                MeatLib.LOGGER.error((Object)e);
            }
            finally {
                it.remove();
            }
        }
    }

    private static void processField(String namespace, RegistrationContext ctx, Field field) {
        try {
            Object o = field.get(null);
            ctx.collectField(namespace, o, field);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

