/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.api.network;

import com.neep.meatlib.api.network.ParamCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.List;
import net.minecraft.class_2540;

public class RecordParamCodec<T>
implements ParamCodec<T> {
    private final Class<T> clazz;
    private final List<ParamCodec<?>> paramCodecs;
    private final Constructor<T> constructor;
    private final List<Field> recordFields = new ObjectArrayList();

    public RecordParamCodec(Class<T> clazz, List<ParamCodec<?>> paramCodecs) {
        this.clazz = clazz;
        this.paramCodecs = paramCodecs;
        Class[] parameters = (Class[])paramCodecs.stream().map(ParamCodec::clazz).toArray(Class[]::new);
        try {
            this.constructor = clazz.getConstructor(parameters);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Constructor not found in given class.");
        }
        RecordComponent[] recordComponents = clazz.getRecordComponents();
        if (paramCodecs.size() != recordComponents.length) {
            throw new IllegalArgumentException(String.format("Number of ParamCodecs does not match number of fields in record '%s'", clazz));
        }
        for (int i = 0; i < recordComponents.length; ++i) {
            RecordComponent comp = recordComponents[i];
            ParamCodec<?> paramCodec = paramCodecs.get(i);
            if (!paramCodec.clazz().isAssignableFrom(comp.getType())) {
                throw new IllegalArgumentException(String.format("Record component of type '%s' does not match ParamCodec class '%s'", comp.getType(), paramCodec.clazz()));
            }
            try {
                Field field = clazz.getDeclaredField(comp.getName());
                field.setAccessible(true);
                this.recordFields.add(field);
                continue;
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("No field named '%s' in class '%s'", comp.getName(), clazz));
            }
        }
    }

    @Override
    public Class<T> clazz() {
        return this.clazz;
    }

    @Override
    public T decode(class_2540 buf) {
        Object[] arguments = new Object[this.paramCodecs.size()];
        for (int i = 0; i < this.paramCodecs.size(); ++i) {
            arguments[i] = this.paramCodecs.get(i).decode(buf);
        }
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalArgumentException("This should probably not happen.");
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e.getCause());
        }
    }

    @Override
    public void encode(T t, class_2540 buf) {
        try {
            for (int i = 0; i < this.paramCodecs.size(); ++i) {
                ParamCodec<?> codec = this.paramCodecs.get(i);
                Field field = this.recordFields.get(i);
                codec.encode(field.get(t), buf);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(String.format("Unable to access a field in '%s'", this.clazz));
        }
    }

    public static <T> Builder<T> builder(Class<T> tClass) {
        return new Builder<T>(tClass);
    }

    public static class Builder<T> {
        private final Class<T> clazz;
        private final List<ParamCodec<?>> paramCodecs = new ObjectArrayList();

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
            if (!clazz.isRecord()) {
                throw new IllegalArgumentException("Class '" + String.valueOf(clazz) + "' is not a record");
            }
        }

        public <V> Builder<T> param(ParamCodec<V> paramCodec) {
            this.paramCodecs.add(paramCodec);
            return this;
        }

        public RecordParamCodec<T> build() {
            return new RecordParamCodec<T>(this.clazz, this.paramCodecs);
        }
    }
}

