/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.primitive;

import com.neep.meatlib.client.screen.primitive.Point;

public interface Rectangle
extends Point {
    @Override
    public int x();

    @Override
    public int y();

    public int w();

    public int h();

    default public Rectangle offset(int dx, int dy) {
        return new Immutable(this.x() + dx, this.y() + dy, this.w(), this.h());
    }

    default public boolean isWithin(double mx, double my) {
        return mx >= (double)this.x() && mx <= (double)(this.x() + this.w()) && my >= (double)this.y() && my <= (double)(this.y() + this.h());
    }

    default public int x2() {
        return this.x() + this.w();
    }

    default public int y2() {
        return this.y() + this.h();
    }

    default public Rectangle withTopLeft(int x, int y) {
        return new Immutable(x, y, this.w(), this.h());
    }

    public static class Immutable
    implements Rectangle {
        public final int x;
        public final int y;
        public final int w;
        public final int h;

        public Immutable(Rectangle rectangle) {
            this.x = rectangle.x();
            this.y = rectangle.y();
            this.w = rectangle.w();
            this.h = rectangle.h();
        }

        public Immutable(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public int x() {
            return this.x;
        }

        @Override
        public int y() {
            return this.y;
        }

        @Override
        public int w() {
            return this.w;
        }

        @Override
        public int h() {
            return this.h;
        }
    }

    public static interface Mutable
    extends Rectangle,
    Point.Mutable {
        default public void setSize(int w, int h) {
            this.setDims(this.x(), this.y(), w, h);
        }

        @Override
        default public void setPos(int x, int y) {
            this.setDims(x, y, this.w(), this.h());
        }

        public void setDims(int var1, int var2, int var3, int var4);
    }
}

