/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget;

import com.neep.meatlib.client.screen.GUIUtil;
import com.neep.meatlib.client.screen.auto.Panel;
import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.ClickableWidget;
import com.neep.neepmeat.api.plc.PLCCols;
import it.unimi.dsi.fastutil.ints.IntConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Matrix4f;

public class ColourSelectWidget
extends Panel {
    private final IntConsumer update;
    private final int a = 255;
    private int r;
    private int g;
    private int b;
    private final List<class_4068> drawables = new ObjectArrayList();
    private final List<class_364> children = new ObjectArrayList();
    private boolean dirty;
    private Consumer<ColourSelectWidget> updatePreview = i -> {};

    public ColourSelectWidget(int initial, IntConsumer update) {
        this.r = initial >> 16 & 0xFF;
        this.g = initial >> 8 & 0xFF;
        this.b = initial & 0xFF;
        this.update = update;
    }

    public ColourSelectWidget preview(Consumer<ColourSelectWidget> preview) {
        this.updatePreview = preview;
        return this;
    }

    private <T extends class_4068 & class_364> T addChild(T child) {
        this.children.add(child);
        this.drawables.add(child);
        return child;
    }

    @Override
    public void init() {
        this.drawables.clear();
        this.children.clear();
        this.h = 30;
        int ey = this.y;
        int eh = 12;
        ColourBar child = this.addChild(new ColourBar(this.x + 1, ey, () -> this.r, this::setR, new int[]{0, 1, 1}));
        child.setDims(this.x, ey, this.w - 1, eh);
        child = this.addChild(new ColourBar(this.x + 1, ey += eh, () -> this.g, this::setG, new int[]{1, 0, 1}));
        child.setDims(this.x, ey, this.w - 1, eh);
        child = this.addChild(new ColourBar(this.x + 1, ey += eh, () -> this.b, this::setB, new int[]{1, 1, 0}));
        child.setDims(this.x, ey, this.w - 1, eh);
        this.h = (ey += eh) - this.y;
    }

    public void setR(int r) {
        this.r = r;
        this.updatePreview.accept(this);
        this.dirty = true;
    }

    public void setG(int g) {
        this.g = g;
        this.updatePreview.accept(this);
        this.dirty = true;
    }

    public void setB(int b) {
        this.b = b;
        this.updatePreview.accept(this);
        this.dirty = true;
    }

    private void update() {
        this.update.accept(this.get());
        this.dirty = false;
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        GUIUtil.renderBorderInner(context, this.x, this.y, this.w, this.h, PLCCols.TEXT.col, 0);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.update();
        return super.method_25406(mouseX, mouseY, button);
    }

    public static void fillGradient(class_4587 matrices, class_4588 vertexConsumer, float startX, float startY, float endX, float endY, float r1, float g1, float b1, float r2, float g2, float b2) {
        float z = 0.0f;
        float a1 = 1.0f;
        float a2 = 1.0f;
        Matrix4f matrix4f = matrices.method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, startX, startY, z).method_22915(r1, g1, b1, a1).method_1344();
        vertexConsumer.method_22918(matrix4f, startX, endY, z).method_22915(r1, g1, b1, a1).method_1344();
        vertexConsumer.method_22918(matrix4f, endX, endY, z).method_22915(r2, g2, b2, a2).method_1344();
        vertexConsumer.method_22918(matrix4f, endX, startY, z).method_22915(r2, g2, b2, a2).method_1344();
    }

    @Override
    protected List<class_4068> drawables() {
        return this.drawables;
    }

    @Override
    public List<class_364> method_25396() {
        return this.children;
    }

    @Override
    public void close() {
        if (this.dirty) {
            this.update();
        }
        super.close();
    }

    public int get() {
        return 0xFF000000 | this.r << 16 | this.g << 8 | this.b;
    }

    public void set(int col) {
        this.r = col >> 16 & 0xFF;
        this.g = col >> 8 & 0xFF;
        this.b = col & 0xFF;
        this.updatePreview.accept(this);
        this.dirty = true;
    }

    public class ColourBar
    implements Rectangle.Mutable,
    ClickableWidget {
        private int x;
        private int y;
        private int w;
        private int h;
        private final IntSupplier value;
        private final IntConsumer set;
        private final int[] a;

        public ColourBar(int x, int y, IntSupplier value, IntConsumer set, int[] a) {
            this.x = x;
            this.y = y;
            this.value = value;
            this.set = set;
            this.a = a;
        }

        public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
            ColourSelectWidget.fillGradient(context.method_51448(), context.method_51450().getBuffer(class_1921.method_51784()), this.x + 1, this.y, this.x + this.w, this.y + this.h, (float)(this.a[0] * ColourSelectWidget.this.r) / 255.0f, (float)(this.a[1] * ColourSelectWidget.this.g) / 255.0f, (float)(this.a[2] * ColourSelectWidget.this.b) / 255.0f, this.a[0] > 0 ? (float)ColourSelectWidget.this.r / 255.0f : 1.0f, this.a[1] > 0 ? (float)ColourSelectWidget.this.g / 255.0f : 1.0f, this.a[2] > 0 ? (float)ColourSelectWidget.this.b / 255.0f : 1.0f);
            int cx = (int)((float)this.x + (float)this.value.getAsInt() / 255.0f * (float)this.w);
            float s = 0.7f;
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_22904((double)cx, (double)((float)this.y + (float)this.h / 2.0f) - 2.5, 0.0);
            matrices.method_22905(s, s, 1.0f);
            GUIUtil.drawCenteredText(context, class_310.method_1551().field_1772, class_2561.method_30163((String)"\u2610"), 0.0f, 0.0f, -1, true);
            matrices.method_22909();
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.isWithin(mouseX, mouseY)) {
                double f = (mouseX - (double)this.x) / (double)this.w;
                this.set.accept((int)(f * 255.0));
            }
            return ClickableWidget.super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.method_25402(mouseX, mouseY, button);
        }

        @Override
        public void setDims(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        @Override
        public int x() {
            return this.x;
        }

        @Override
        public int y() {
            return this.y;
        }

        @Override
        public int w() {
            return this.w;
        }

        @Override
        public int h() {
            return this.h;
        }

        public void method_25365(boolean focused) {
        }

        public boolean method_25370() {
            return false;
        }
    }
}

