/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget;

import com.neep.meatlib.client.screen.primitive.Rectangle;
import com.neep.meatlib.client.screen.widget.AbstractNumberTextField;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class IntNumberTextField
extends AbstractNumberTextField<Integer>
implements Rectangle.Mutable {
    private final Consumer<IntNumberTextField> update;
    private final int min;
    private final int max;
    private final int minIncrement;
    private final int maxIncrement;

    public IntNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Consumer<IntNumberTextField> update, int min, int max) {
        this(textRenderer, x, y, width, height, prefix, update, min, max, 1, 16);
    }

    public IntNumberTextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix, Consumer<IntNumberTextField> update, int min, int max, int minIncrement, int maxIncrement) {
        super(textRenderer, x, y, width, height, prefix);
        this.update = update;
        this.min = min;
        this.max = max;
        this.minIncrement = minIncrement;
        this.maxIncrement = maxIncrement;
    }

    @Override
    protected void update() {
        this.update.accept(this);
    }

    @Override
    protected boolean isValidString(String text) {
        return text.matches("[+\\-0-9E]*");
    }

    @Override
    protected String valueToString(Integer value) {
        return Integer.toString(value);
    }

    protected int parseValue(String text) {
        try {
            return class_3532.method_15340((int)Integer.parseInt(text), (int)this.min, (int)this.max);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private float scrollMultiplier() {
        return class_437.method_25442() ? (float)this.minIncrement : (float)this.maxIncrement;
    }

    @Override
    protected Integer applyScroll(String text, double amount) {
        return class_3532.method_15340((int)((int)((double)this.parseValue(text) + amount * (double)this.scrollMultiplier())), (int)this.min, (int)this.max);
    }

    public int parse() {
        return this.parseValue(this.text());
    }

    @Override
    public void setDims(int x, int y, int w, int h) {
        super.setDims(x, y, w, h);
    }
}

