/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.client.screen.widget.config;

import com.neep.meatlib.client.screen.widget.NumberListConfigWidget;
import com.neep.meatlib.screen.NumberListConfigHandler;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public abstract class FloatListConfigWidget
extends NumberListConfigWidget<Float, FloatList> {
    public FloatListConfigWidget(int x, int y, int w, int h, NumberListConfigHandler<Float, FloatList> handler) {
        super(x, y, w, h, handler);
    }

    @Override
    protected FloatList createList() {
        return new FloatArrayList();
    }

    @Override
    protected Float parseValue(String text) {
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    protected Float zero() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected String valueToString(Float value) {
        return Float.toString(value.floatValue());
    }

    @Override
    protected boolean validString(String string) {
        return string.matches("[+\\-.0-9E]*");
    }

    @Override
    protected Float applyScroll(String text, Double amount) {
        return Float.valueOf((float)((double)this.parseValue(text).floatValue() + amount * (double)this.scrollMultiplier()));
    }
}

