/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.larkdown.command;

import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.util.StringTokenView;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class CommandOptions {
    private final Map<String, String> kvs = new HashMap<String, String>();

    public CommandOptions() {
    }

    public CommandOptions(String options) {
        Pair<String, String> kv;
        StringTokenView view = new StringTokenView(options);
        do {
            if ((kv = CommandOptions.readKeyValue(view)) == null) continue;
            this.kvs.put((String)kv.key(), (String)kv.value());
        } while (!view.eof() && kv != null);
    }

    @Nullable
    private static Pair<String, String> readKeyValue(StringTokenView view) {
        String key = view.nextIdentifier();
        if (!key.isEmpty() && view.nextThing() == '=') {
            char c;
            StringBuilder sb = new StringBuilder();
            do {
                if ((c = view.next()) == ',') continue;
                sb.append(c);
            } while (c != ',' && !view.eof());
            return Pair.of((Object)key, (Object)sb.toString());
        }
        return null;
    }

    @Nullable
    private String getString(String key) {
        return this.kvs.get(key);
    }

    public String getString(String key, String fallback) throws LarkdownParseException {
        return this.kvs.getOrDefault(key, fallback);
    }

    public int getInt(String key, int fallback) throws LarkdownParseException {
        String value = this.getString(key);
        if (value == null) {
            return fallback;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new LarkdownParseException(e.getMessage());
        }
    }

    public float getFloat(String key, float fallback) throws LarkdownParseException {
        String value = this.getString(key);
        if (value == null) {
            return fallback;
        }
        try {
            return Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            throw new LarkdownParseException(e.getMessage());
        }
    }
}

