/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.network;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.network.Sender;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;

public class ChannelFormatFormatImpl<T>
implements ChannelFormat<T> {
    private final List<ParamCodec<Object>> codecs;
    private final List<Class<?>> invokeParameters;
    private final Emitter<T> emitter;
    private final Method method;

    private ChannelFormatFormatImpl(Class<T> clazz, List<ParamCodec<?>> codecs) {
        this.codecs = codecs.stream().map(c -> c).toList();
        this.invokeParameters = codecs.stream().map(ParamCodec::clazz).toList();
        this.method = ChannelFormatFormatImpl.findMethod(clazz, this.invokeParameters.toArray(new Class[0]));
        Emitter<Object> emitter = sender -> Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            String methodName = method.getName();
            if (methodName.equals(this.method.getName())) {
                this.send(sender, args);
                return false;
            }
            return switch (methodName) {
                case "toString" -> "proxy of " + String.valueOf(this.method);
                case "equals" -> false;
                case "hashCode" -> 0;
                default -> throw new IllegalStateException("Unexpected method name: " + methodName);
            };
        });
        this.emitter = emitter;
    }

    private static Method findMethod(Class<?> clazz, Class<?>[] invokeParameters) {
        Method[] methods = clazz.getMethods();
        if (methods.length == 1) {
            Method method = methods[0];
            if (ChannelFormatFormatImpl.parametersMatch(method, invokeParameters)) {
                return method;
            }
        } else {
            for (Method method : clazz.getMethods()) {
                if (!ChannelFormatFormatImpl.parametersMatch(method, invokeParameters)) continue;
                return method;
            }
        }
        throw new IllegalArgumentException("Method not found in given class. Is it called 'apply' and do its parameters match those specified in the builder?");
    }

    private static boolean parametersMatch(Method method, Class<?>[] invokeParameters) {
        Class<?>[] methodParameters = method.getParameterTypes();
        if (methodParameters.length != invokeParameters.length) {
            return false;
        }
        for (int i = 0; i < methodParameters.length; ++i) {
            if (methodParameters[i].isAssignableFrom(invokeParameters[i])) continue;
            return false;
        }
        return true;
    }

    public static <T> Builder<T> builder(Class<T> clazz) {
        return new Builder<T>(clazz);
    }

    @Override
    public T emitter(Sender<T> sender) {
        return this.emitter.create(sender);
    }

    public void send(Sender<T> sender, Object ... objects) {
        if (!(this.invokeParameters.isEmpty() || objects != null && objects.length == this.invokeParameters.size())) {
            throw new IllegalStateException("Incorrect number of parameters");
        }
        class_2540 buf = PacketByteBufs.create();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                ParamCodec<Object> codec = this.codecs.get(i);
                Object object = objects[i];
                codec.encode(object, buf);
            }
        }
        sender.send(buf);
    }

    @Override
    public void receive(T listener, class_2540 buf, Executor executor) {
        Object[] arguments = new Object[this.invokeParameters.size()];
        for (int i = 0; i < this.codecs.size(); ++i) {
            Object object;
            ParamCodec<Object> codec = this.codecs.get(i);
            arguments[i] = object = codec.decode(buf);
        }
        executor.execute(() -> {
            try {
                this.method.invoke(listener, arguments);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("This should probably not happen.");
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getCause());
            }
        });
    }

    public static interface Emitter<T> {
        public T create(Sender<T> var1);
    }

    public static class Builder<T> {
        private final Class<T> clazz;
        List<ParamCodec<?>> codecs = new ArrayList();

        public Builder(Class<T> clazz) {
            this.clazz = clazz;
        }

        public <V> Builder<T> param(ParamCodec<V> codec) {
            this.codecs.add(codec);
            return this;
        }

        public ChannelFormat<T> build() {
            return new ChannelFormatFormatImpl<T>(this.clazz, this.codecs);
        }
    }
}

