/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.network.screen;

import com.neep.meatlib.api.network.ParamCodec;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;

public class ScreenChannel<T> {
    private final class_2960 name;
    private final ParamCodec<T> codec;
    private List<ServerHandler> serverHandlers;

    public static Sender server(class_3222 player) {
        return (channel, buf) -> ServerPlayNetworking.send((class_3222)player, (class_2960)channel, (class_2540)buf);
    }

    public ScreenChannel(class_2960 name, ParamCodec<T> codec) {
        this.name = name;
        this.codec = codec;
    }

    public void send(T t, Sender sender) {
        class_2540 buf = PacketByteBufs.create();
        this.codec.encode(t, buf);
        sender.send(this.name, buf);
    }

    public void attach(Consumer<T> consumer, class_3222 player) {
        this.serverHandlers.add(new ServerHandler(player, consumer));
    }

    public void close() {
        for (ServerHandler handler : this.serverHandlers) {
            handler.close();
        }
    }

    private static interface Sender {
        public void send(class_2960 var1, class_2540 var2);
    }

    private class ServerHandler {
        private final class_3222 player;
        private final Consumer<T> consumer;

        public ServerHandler(class_3222 player, Consumer<T> consumer) {
            this.player = player;
            this.consumer = consumer;
            ServerPlayNetworking.registerReceiver((class_3244)player.field_13987, (class_2960)ScreenChannel.this.name, (server, player1, handler, buf, responseSender) -> {
                Object t = ScreenChannel.this.codec.decode(buf);
                server.execute(() -> this.consumer.accept(t));
            });
        }

        public void close() {
            ServerPlayNetworking.unregisterReceiver((class_3244)this.player.field_13987, (class_2960)ScreenChannel.this.name);
        }
    }
}

