/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatlib.registry;

import com.google.common.base.MoreObjects;
import com.neep.meatlib.MeatLib;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.SelfRegistrable;
import com.neep.meatlib.registry.annotation.Path;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class RegistrationContext {
    private final String namespace;
    private final Set<Class<?>> validClasses;
    private boolean registered = false;
    private final List<RootNode> rootNodes = new ObjectArrayList();
    private final Map<Object, Node> allNodes = new IdentityHashMap<Object, Node>();

    public RegistrationContext(String defaultNamespace) {
        this.namespace = defaultNamespace;
        this.validClasses = Set.of(class_1792.class, class_2248.class);
    }

    public String namespace() {
        return this.namespace;
    }

    public void collectField(String namespace, Object object, Field field) {
        String path = field.getName().toLowerCase();
        @Nullable Path customPath = field.getAnnotation(Path.class);
        if (customPath != null) {
            path = customPath.value();
        }
        class_2960 id = new class_2960(namespace, path);
        this.addParent(id, object);
    }

    public <T> T addParent(class_2960 id, T object) {
        SelfRegistrable registrable = RegistrationContext.toRegistrable(object);
        if (registrable != null) {
            this.allNodes.compute(object, (o, n) -> {
                if (n instanceof RootNode) {
                    RootNode rootNode = (RootNode)n;
                    rootNode.setId(id);
                    return rootNode;
                }
                RootNode rootNode = new RootNode((Node)n, registrable);
                rootNode.setId(id);
                this.rootNodes.add(rootNode);
                return rootNode;
            });
        } else {
            MeatLib.LOGGER.error("Cannot extract a SelfRegistrable from root object {} ", object);
        }
        return object;
    }

    @Nullable
    private static SelfRegistrable toRegistrable(Object object) {
        if (object instanceof SelfRegistrable) {
            SelfRegistrable selfRegistrable = (SelfRegistrable)object;
            return selfRegistrable;
        }
        if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            return SelfRegistrable.ofItem(item);
        }
        if (object instanceof class_2248) {
            class_2248 block = (class_2248)object;
            return SelfRegistrable.ofBlock(block);
        }
        return null;
    }

    private <T extends SelfRegistrable> T append(Object parent, Object key, T entry, SelfRegistrable.PathProcessor processor) {
        Node parentNode = this.allNodes.get(parent);
        if (parentNode == null) {
            @Nullable SelfRegistrable rootRegistrable = RegistrationContext.toRegistrable(parent);
            if (rootRegistrable != null) {
                parentNode = new Node(rootRegistrable);
                this.allNodes.put(parent, parentNode);
            } else {
                MeatLib.LOGGER.error("Cannot extract a SelfRegistrable from root object {} ", parent);
                return entry;
            }
        }
        Node node = this.allNodes.computeIfAbsent(key, k -> new Node(entry, processor));
        if (node.processor != processor) {
            node.setProcessor(processor);
        }
        parentNode.addChild(node);
        return entry;
    }

    public <T extends SelfRegistrable> T append(Object root, T entry) {
        return this.append(root, entry, entry, s -> s);
    }

    public <T extends SelfRegistrable> T appendItem(Object root, T entry) {
        return this.append(root, entry);
    }

    public <T> T append(Object object, T entry) {
        @Nullable SelfRegistrable registrable = RegistrationContext.toRegistrable(entry);
        if (registrable != null) {
            this.append(object, (SelfRegistrable)entry);
        }
        return entry;
    }

    public <T extends SelfRegistrable> T append(Object object, T entry, SelfRegistrable.PathProcessor processor) {
        return this.append(object, entry, entry, processor);
    }

    public <T extends SelfRegistrable> T append(Object object, T entry, String path) {
        return this.append(object, entry, (String s) -> path);
    }

    public boolean isValidClass(Class<?> f) {
        for (Class<?> clazz : this.validClasses) {
            if (!clazz.isAssignableFrom(f)) continue;
            return true;
        }
        return false;
    }

    public void registerAll() {
        if (this.registered) {
            throw new IllegalStateException(String.valueOf(this) + ": registerAll called more than once!");
        }
        this.registered = true;
        this.rootNodes.forEach(node -> node.traverse());
    }

    public <T extends class_2248> T withItem(T block, ItemSettings itemSettings) {
        itemSettings.create(block, this);
        return block;
    }

    static class Node {
        protected final SelfRegistrable registrable;
        protected SelfRegistrable.PathProcessor processor;
        protected final Set<Node> children = new HashSet<Node>();

        public Node(SelfRegistrable registrable, SelfRegistrable.PathProcessor processor) {
            this.registrable = registrable;
            this.processor = processor;
        }

        public Node(SelfRegistrable registrable) {
            this.registrable = registrable;
            this.processor = s -> s;
        }

        public void traverse(String namespace, String path) {
            String currentPath = this.processor.apply(path);
            this.registrable.register(new class_2960(namespace, currentPath));
            for (Node child : this.children) {
                child.traverse(namespace, currentPath);
            }
        }

        public Node addChild(Node node) {
            this.children.add(node);
            return node;
        }

        public void setProcessor(SelfRegistrable.PathProcessor processor) {
            this.processor = processor;
        }

        public int hashCode() {
            return this.registrable.hashCode();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof Node)) return false;
            Node node = (Node)obj;
            if (node.registrable != this.registrable) return false;
            return true;
        }
    }

    static class RootNode
    extends Node {
        @Nullable
        private class_2960 id;

        public RootNode(SelfRegistrable registrable) {
            super(registrable);
        }

        public RootNode(@Nullable Node previous, SelfRegistrable registrable) {
            super(registrable);
            if (previous != null) {
                this.children.addAll(previous.children);
            }
        }

        public void setId(class_2960 id) {
            this.id = id;
        }

        public void traverse() {
            if (this.id == null) {
                MeatLib.LOGGER.error("Null root object path for " + String.valueOf(this.registrable) + " of class " + String.valueOf(this.registrable.getClass()) + " " + this.registrable.hashCode());
                return;
            }
            this.registrable.register(this.id);
            for (Node child : this.children) {
                child.traverse(this.id.method_12836(), this.id.method_12832());
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
        }
    }
}

