/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.client.renderer.meatgun;

import com.neep.meatweapons.client.renderer.meatgun.BasePistolModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.BaseStaffModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.BatteryModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.BloodthrowerModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.BosherModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.ChuggerModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.DoubleCarouselModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.GrenadeLauncherModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.HalberdModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.HomingModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.LongBoiModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.MeatgunModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.PhageRaySpeedModifierModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.PistolModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.ShockStaffModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.ShortPhageRayModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.TripleCarouselModuleRenderer;
import com.neep.meatweapons.client.renderer.meatgun.UnderbarrelModuleRenderer;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class MeatgunModuleRenderers {
    private static final Map<MeatgunModule.Type<?>, MeatgunModuleRenderer.Factory<?>> RENDERER_FACTORIES = new IdentityHashMap();
    private static final Map<MeatgunModule.Type<? extends MeatgunModule>, MeatgunModuleRenderer<?>> RENDERERS = new IdentityHashMap();

    public static <T extends MeatgunModule> void register(MeatgunModule.Type<T> type, MeatgunModuleRenderer.Factory<T> factory) {
        RENDERER_FACTORIES.put(type, factory);
    }

    public static <T extends MeatgunModule> MeatgunModuleRenderer<T> get(T module) {
        return RENDERERS.computeIfAbsent(module.getType(), id -> RENDERER_FACTORIES.get(module.getType()).create(class_310.method_1551()));
    }

    public static void init() {
        MeatgunModuleRenderers.register(MeatgunModules.BASE_PISTOL, BasePistolModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.BASE_STAFF, BaseStaffModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.PISTOL, PistolModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.CHUGGER, ChuggerModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.BOSHER, BosherModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.LONG_BOI, LongBoiModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.GRENADE_LAUNCHER, GrenadeLauncherModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.BLOODTHROWER, BloodthrowerModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.SHORT_PHAGE_RAY, ShortPhageRayModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.TRIPLE_CAROUSEL, TripleCarouselModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.DOUBLE_CAROUSEL, DoubleCarouselModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.UNDERBARREL, UnderbarrelModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.BATTERY, BatteryModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.HOMING_BRAIN, HomingModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.PHAGE_RAY_SPEED_MODIFIER, PhageRaySpeedModifierModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.HALBERD, HalberdModuleRenderer::new);
        MeatgunModuleRenderers.register(MeatgunModules.SHOCK_STAFF, ShockStaffModuleRenderer::new);
    }
}

