/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.entity;

import com.google.common.collect.Lists;
import com.neep.meatweapons.client.MWKeys;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5275;
import net.minecraft.class_5459;
import net.minecraft.class_5712;

public abstract class AbstractVehicleEntity
extends class_1297 {
    protected float velocityDecay;
    protected float yawVelocity;
    protected float roll;
    protected float prevRoll;
    private int delta;
    private double x;
    private double y;
    private double z;
    protected double vehicleYaw;
    protected double vehiclePitch;
    protected boolean pressingLeft;
    protected boolean pressingRight;
    protected boolean pressingForward;
    protected boolean pressingBack;
    protected boolean pressingUp;
    protected boolean pressingDown;
    protected boolean prevForward;
    protected boolean prevBack;
    protected boolean prevLeft;
    protected boolean prevRight;
    protected boolean prevUp;
    protected boolean prevDown;
    protected double fallVelocity;
    protected boolean powered = true;
    protected int health;
    private static final class_2940<Float> ROLL = class_2945.method_12791(AbstractVehicleEntity.class, (class_2941)class_2943.field_13320);

    public AbstractVehicleEntity(class_1299<? extends class_1297> entityType, class_1937 world) {
        super(entityType, world);
        this.field_23807 = true;
        this.health = 15;
    }

    public abstract class_1799 asStack();

    public abstract class_3414 getDamageSound();

    protected float method_18378(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068;
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ROLL, (Object)Float.valueOf(0.0f));
    }

    public boolean method_30949(class_1297 other) {
        return AbstractVehicleEntity.canCollide(this, other);
    }

    public static boolean canCollide(class_1297 entity, class_1297 other) {
        return (other.method_30948() || other.method_5810()) && !entity.method_5794(other);
    }

    public boolean method_30948() {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_30633(class_2350.class_2351 portalAxis, class_5459.class_5460 portalRect) {
        return class_1309.method_31079((class_243)super.method_30633(portalAxis, portalRect));
    }

    public double method_5621() {
        return 0.2;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_37908().field_9236 || this.method_31481()) {
            return true;
        }
        this.health -= (int)amount;
        this.method_5785();
        this.method_32875(class_5712.field_28736, source.method_5529());
        this.method_37908().method_43129(null, (class_1297)this, this.getDamageSound(), class_3419.field_15254, 1.0f, 1.0f);
        if (this.health <= 0) {
            this.dropDead();
            this.method_31472();
        }
        return true;
    }

    public void method_5697(class_1297 entity) {
        if (entity instanceof AbstractVehicleEntity) {
            if (entity.method_5829().field_1322 < this.method_5829().field_1325) {
                super.method_5697(entity);
            }
        } else if (entity.method_5829().field_1322 <= this.method_5829().field_1322) {
            super.method_5697(entity);
        }
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.vehicleYaw = yaw;
        this.vehiclePitch = pitch;
        this.delta = 10;
    }

    public class_2350 method_5755() {
        return this.method_5735().method_10170();
    }

    public void method_5773() {
        super.method_5773();
        this.interpolatePosition();
        if (this.method_5787()) {
            this.updateVelocity();
            if (this.method_37908().field_9236) {
                this.updateKeys();
                this.updateMotion();
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.method_5852();
        List otherEntities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!otherEntities.isEmpty()) {
            boolean soundEvent = !this.method_37908().field_9236 && !(this.method_5642() instanceof class_1657);
            for (class_1297 entity : otherEntities) {
                if (entity.method_5626((class_1297)this)) continue;
                if (soundEvent && this.method_5685().size() < 2 && !entity.method_5765() && entity.method_17681() < this.method_17681() && entity instanceof class_1309 && !(entity instanceof class_1480) && !(entity instanceof class_1657)) {
                    entity.method_5804((class_1297)this);
                    continue;
                }
                this.method_5697(entity);
            }
        }
        this.calculateRoll();
    }

    private void interpolatePosition() {
        if (this.method_5787()) {
            this.delta = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.delta <= 0) {
            return;
        }
        double dx = this.method_23317() + (this.x - this.method_23317()) / (double)this.delta;
        double dy = this.method_23318() + (this.y - this.method_23318()) / (double)this.delta;
        double dz = this.method_23321() + (this.z - this.method_23321()) / (double)this.delta;
        double dyaw = class_3532.method_15338((double)(this.vehicleYaw - (double)this.method_36454()));
        this.method_36456(this.method_36454() + (float)dyaw / (float)this.delta);
        this.method_36457(this.method_36455() + (float)(this.vehiclePitch - (double)this.method_36455()) / (float)this.delta);
        --this.delta;
        this.method_5814(dx, dy, dz);
        this.method_5710(this.method_36454(), this.method_36455());
    }

    private void updateVelocity() {
        this.velocityDecay = this.method_24828() ? 0.2f : 0.9f;
        float verticalVelocityDecay = 0.8f;
        class_243 vec3d = this.method_18798();
        this.method_18800(vec3d.field_1352 * (double)this.velocityDecay, vec3d.field_1351 * (double)verticalVelocityDecay, vec3d.field_1350 * (double)this.velocityDecay);
        this.yawVelocity *= this.velocityDecay;
    }

    protected void updateKeys() {
        class_315 options = class_310.method_1551().field_1690;
        this.prevForward = this.pressingForward;
        this.prevBack = this.pressingBack;
        this.prevLeft = this.pressingLeft;
        this.prevRight = this.pressingRight;
        this.prevUp = this.pressingUp;
        this.prevDown = this.pressingDown;
        this.pressingForward = options.field_1894.method_1434();
        this.pressingBack = options.field_1881.method_1434();
        this.pressingLeft = options.field_1913.method_1434();
        this.pressingRight = options.field_1849.method_1434();
        this.pressingUp = options.field_1903.method_1434();
        this.pressingDown = MWKeys.AIRTRUCK_DOWN.method_1434();
    }

    protected void updateMotion() {
        if (!this.method_5782()) {
            return;
        }
        float forwardsVelocity = 0.0f;
        float upVelocity = 0.0f;
        if (this.pressingLeft) {
            this.yawVelocity -= 1.0f;
        }
        if (this.pressingRight) {
            this.yawVelocity += 1.0f;
        }
        if (this.pressingRight != this.pressingLeft && !this.pressingForward && !this.pressingBack) {
            forwardsVelocity += 0.005f;
        }
        this.method_36456(this.method_36454() + this.yawVelocity);
        if (this.pressingForward) {
            forwardsVelocity += 0.04f;
        }
        if (this.pressingBack) {
            forwardsVelocity -= 0.005f;
        }
        if (this.pressingUp) {
            upVelocity += 0.08f;
        }
        if (this.pressingDown) {
            upVelocity -= 0.08f;
        }
        this.method_18799(this.method_18798().method_1031((double)(class_3532.method_15374((float)(-this.method_36454() * ((float)Math.PI / 180))) * forwardsVelocity), (double)upVelocity, (double)(class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180))) * forwardsVelocity)));
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 updater) {
        if (!this.method_5626(passenger)) {
            return;
        }
        float driverOffset = 1.0f;
        float trailerOffset = -1.0f;
        float xOffset = driverOffset;
        float yOffset = (float)(this.method_5621() + passenger.method_5678());
        if (this.method_5685().size() > 1) {
            int i = this.method_5685().indexOf(passenger);
            float f = xOffset = i == 0 ? driverOffset : trailerOffset;
            if (passenger instanceof class_1429) {
                xOffset += 0.2f;
            }
        }
        class_243 i = new class_243((double)xOffset, 0.0, 0.0).method_1024((float)((double)(-this.method_36454()) * Math.PI / 180.0 - 1.5707963267948966));
        passenger.method_5814(this.method_23317() + i.field_1352, this.method_23318() + (double)yOffset, this.method_23321() + i.field_1350);
        passenger.method_36456(passenger.method_36454() + this.yawVelocity);
        passenger.method_5847(passenger.method_5791() + this.yawVelocity);
        this.copyEntityData(passenger);
        if (passenger instanceof class_1429 && this.method_5685().size() > 1) {
            int animalYaw = passenger.method_5628() % 2 == 0 ? 90 : 270;
            passenger.method_5636(((class_1429)passenger).field_6283 + (float)animalYaw);
            passenger.method_5847(passenger.method_5791() + (float)animalYaw);
        }
    }

    protected void copyEntityData(class_1297 entity) {
        entity.method_5636(this.method_36454());
        float f = class_3532.method_15393((float)(entity.method_36454() - this.method_36454()));
        float g = class_3532.method_15363((float)f, (float)-105.0f, (float)105.0f);
        entity.field_5982 += g - f;
        entity.method_36456(entity.method_36454() + g - f);
        entity.method_5847(entity.method_36454());
    }

    public class_243 method_24829(class_1309 passenger) {
        class_243 vec3d = AbstractVehicleEntity.method_24826((double)(this.method_17681() * class_3532.field_15724), (double)passenger.method_17681(), (float)passenger.method_36454());
        double d = this.method_23317() + vec3d.field_1352;
        double e = this.method_23321() + vec3d.field_1350;
        class_2338 blockPos = new class_2338((int)d, (int)this.method_5829().field_1325, (int)e).method_10074();
        if (!this.method_37908().method_22351(blockPos)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.method_37908().method_30347(blockPos);
            if (class_5275.method_27932((double)f)) {
                list.add(new class_243(d, (double)blockPos.method_10264() + f, e));
            }
            if (class_5275.method_27932((double)(g = this.method_37908().method_30347(blockPos)))) {
                list.add(new class_243(d, (double)blockPos.method_10264() + g, e));
            }
            for (class_4050 entityPose : passenger.method_24831()) {
                for (class_243 vec3d2 : list) {
                    if (!class_5275.method_33353((class_1941)this.method_37908(), (class_243)vec3d2, (class_1309)passenger, (class_4050)entityPose)) continue;
                    passenger.method_18380(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.method_24829(passenger);
    }

    public void method_5644(class_1297 passenger) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    protected void method_5749(class_2487 nbt) {
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236) {
            if (player.method_5715()) {
                this.dropDead();
                this.method_31472();
                return class_1269.field_5812;
            }
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        this.fallVelocity = this.method_18798().field_1351;
        if (this.method_5765()) {
            return;
        }
        if (onGround) {
            if (this.field_6017 > 3.0f && !this.powered) {
                this.method_5747(this.field_6017, 1.0f, this.method_5770().method_48963().method_48827());
                if (!this.method_37908().field_9236 && !this.method_31481()) {
                    this.method_5768();
                    this.dropDead();
                }
            }
            this.field_6017 = 0.0f;
        } else if (!this.method_37908().method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517) && heightDifference < 0.0) {
            this.field_6017 = (float)((double)this.field_6017 - heightDifference);
        }
    }

    public void calculateRoll() {
        this.prevRoll = this.getRoll();
        this.setRoll((float)(this.method_18798().method_37267() * (double)this.yawVelocity));
        this.method_36457((float)((double)((float)(-this.method_18798().method_10214())) * this.method_18798().method_37267() * 10.0));
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2;
    }

    public class_1309 method_5642() {
        class_1309 living;
        class_1297 class_12972 = this.method_31483();
        return class_12972 instanceof class_1309 ? (living = (class_1309)class_12972) : null;
    }

    public class_2596<class_2602> method_18002() {
        return new class_2604((class_1297)this);
    }

    public class_1799 method_31480() {
        return this.asStack();
    }

    public void dropDead() {
        this.method_5775(this.asStack());
    }

    public void setRoll(float roll) {
        this.roll = roll;
        this.method_5841().method_12778(ROLL, (Object)Float.valueOf(roll));
    }

    public float getRoll() {
        return this.roll;
    }

    public float getRoll(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.prevRoll, (float)this.getRoll());
    }
}

