/*
 * Decompiled with CFR 0.152.
 */
package com.neep.meatweapons.meatgun.module;

import com.neep.meatlib.network.PacketBufUtil;
import com.neep.meatweapons.entity.HitOnCollideEntity;
import com.neep.meatweapons.interfaces.HookableEntity;
import com.neep.meatweapons.item.BaseGunItem;
import com.neep.meatweapons.meatgun.RootModuleHolder;
import com.neep.meatweapons.meatgun.module.MeatgunModule;
import com.neep.meatweapons.meatgun.module.MeatgunModules;
import com.neep.meatweapons.meatgun.module.MeleeModule;
import com.neep.meatweapons.network.MWAttackC2SPacket;
import com.neep.meatweapons.network.MeatgunNetwork;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.util.NMMaths;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2833;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3966;

public class HalberdModule
extends MeleeModule {
    private boolean triggerHeld;
    private int triggerTicks;
    private int swingDownCooldown;
    private int hookGrabCooldown;

    public HalberdModule(RootModuleHolder.Listener listener) {
        super(listener, List.of());
    }

    public HalberdModule(RootModuleHolder.Listener listener, class_2487 nbt) {
        this(listener);
    }

    @Override
    public MeatgunModule.Type<? extends MeatgunModule> getType() {
        return MeatgunModules.HALBERD;
    }

    @Override
    public void trigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        super.trigger(world, player, stack, id, pitch, yaw, handType, hand);
        if (id == 2 && this.swingDownCooldown == 0) {
            this.fireBeam(world, player, pitch, yaw, 3.0, hand);
            world.method_43129(null, (class_1297)player, class_3417.field_14706, class_3419.field_15248, 1.0f, 1.0f);
            MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("blade_swing_down", null);
            this.swingDownCooldown = 15;
        }
        if (id == 1) {
            if (player.method_5854() != null) {
                this.hookWhenMounted(world, player, player.method_5854(), pitch, yaw, hand);
            } else if (player.method_5624()) {
                this.triggerHeld = true;
                MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("upper_thrust", null);
                this.sync(player);
            }
        }
    }

    @Override
    public void release(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        super.release(world, player, stack, id, pitch, yaw, handType, hand);
        if (id == 1) {
            if (this.triggerTicks >= 10) {
                this.thrustForwards(world, player, pitch, yaw, hand);
            }
            this.triggerHeld = false;
            this.triggerTicks = 0;
            this.sync(player);
        }
    }

    @Override
    public void tickTrigger(class_1937 world, class_1657 player, class_1799 stack, int id, double pitch, double yaw, MWAttackC2SPacket.HandType handType, class_1268 hand) {
        super.tickTrigger(world, player, stack, id, pitch, yaw, handType, hand);
        if (id == 1 && player.method_5624()) {
            this.triggerTicks = Math.min(this.triggerTicks + 1, 30);
            if (!this.triggerHeld) {
                this.triggerHeld = true;
                MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("upper_thrust", null);
                this.sync(player);
            }
        }
    }

    @Override
    public void tick(class_1657 player) {
        super.tick(player);
        this.swingDownCooldown = Math.max(0, this.swingDownCooldown - 1);
        this.hookGrabCooldown = Math.max(0, this.hookGrabCooldown - 1);
        if (!player.method_5624()) {
            this.triggerTicks = 0;
            if (this.triggerHeld) {
                this.triggerHeld = false;
                this.listener.markDirty(RootModuleHolder.Reason.SAVE_DATA);
            }
        }
    }

    private void sync(class_1657 player) {
        int slot = player.field_7514.method_7395(this.listener.getHolder().getOwningItemStack());
        MeatgunNetwork.syncModule(slot, player, this);
    }

    protected void hookWhenMounted(class_1937 world, class_1657 player, class_1297 vehicle, double pitch, double yaw, class_1268 hand) {
        class_1297 class_12972;
        if (this.hookGrabCooldown > 0) {
            return;
        }
        this.hookGrabCooldown = 5;
        world.method_43129(null, (class_1297)player, class_3417.field_14706, class_3419.field_15248, 0.5f, 1.0f);
        class_243 pos = player.method_33571();
        class_243 end = pos.method_1019(NMMaths.getRotationVector(pitch, yaw).method_1021(4.0));
        class_3966 target = BaseGunItem.hitScan((class_1309)player, pos, end, 4.0, e -> e != vehicle, (world1, pos1, end1, width, maxTime, showRadius) -> {}, 0.1f).orElse(null);
        if (target != null && (class_12972 = target.method_17782()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.hookGrabCooldown = 20;
                world.method_43129(null, (class_1297)player, class_3417.field_17614, class_3419.field_15248, 1.0f, 1.0f);
                class_243 offset = livingEntity.method_19538().method_1020(player.method_19538());
                class_2540 buf = PacketByteBufs.create();
                PacketBufUtil.writeVec3d(buf, offset);
                MeatgunNetwork.SEND_ANIMATION.emitter(player).apply("hook_grab", buf);
                if (livingEntity.method_5765() && player.method_6051().method_43056()) {
                    livingEntity.method_29239();
                }
                ((HookableEntity)livingEntity).meatweapons$setHookParent((class_1297)player, offset);
                ((HookableEntity)livingEntity).meatweapons$setHookTicks(60);
                livingEntity.method_5643(world.method_48963().method_48802(player), 2.0f);
            }
        } else {
            MeatgunNetwork.sendRecoil((class_3222)player, MeatgunNetwork.RecoilDirection.UP, 7.0f, 0.2f, 0.7f, 0.03f, hand);
        }
    }

    protected void thrustForwards(class_1937 world, class_1657 player, double pitch, double yaw, class_1268 hand) {
        double f = 0.7;
        if (!player.method_6128()) {
            player.method_5762(f * Math.sin(-yaw), 0.4, f * Math.cos(-yaw));
            player.field_6037 = true;
            player.field_6007 = true;
        }
        ((HitOnCollideEntity)player).meatweapons$setActiveTicks(20);
        ((HitOnCollideEntity)player).meatweapons$setDamage(this.baseDamage * 1.1f);
        MeatgunNetwork.sendRecoil((class_3222)player, MeatgunNetwork.RecoilDirection.UP, 7.0f, 0.2f, 0.7f, 0.03f, hand);
    }

    public static void onEntityCollide(class_1657 origin, class_1297 target, int ticksRemaining, float damage) {
        if (!origin.method_37908().method_8608()) {
            class_243 velocity = origin.method_18798();
            if (ticksRemaining > 0 && Math.abs(velocity.field_1352) > 0.05 && Math.abs(velocity.field_1350) > 0.05) {
                target.method_5643(origin.method_37908().method_48963().method_48802(origin), damage);
            }
        }
    }

    public static void onOnVehicleMove(class_2833 packet, class_1297 entity, class_3218 serverWorld, double d, double e, double f, double g, double h, double i, float j, float k, double l, double m, double n, double o, double p, boolean bl, boolean bl2) {
        NeepMeat.LOGGER.info("l: {}, m: {}, n: {}", (Object)l, (Object)m, (Object)n);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt) {
        super.writeNbt(nbt);
        nbt.method_10556("trigger_held", this.triggerHeld);
        nbt.method_10569("trigger_ticks", this.triggerTicks);
        nbt.method_10569("down_cooldown", this.swingDownCooldown);
        nbt.method_10569("grab_cooldown", this.hookGrabCooldown);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt) {
        super.readNbt(nbt);
        this.triggerHeld = nbt.method_10577("trigger_held");
        this.triggerTicks = nbt.method_10550("trigger_ticks");
        this.swingDownCooldown = nbt.method_10550("down_cooldown");
        this.hookGrabCooldown = nbt.method_10550("grab_cooldown");
    }

    public boolean triggerHeld() {
        return this.triggerHeld;
    }
}

