/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.DirectReadPort;
import com.neep.neepbus.util.MultiCachingSender;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.SimpleReadPort;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.spongepowered.include.com.google.common.primitives.Ints;

public class AddressDecoderBlockEntity
extends SyncableBlockEntity
implements ConfigProvider {
    protected final int maxOutputs;
    protected final CachingSender readSender = new CachingSender(() -> ((AddressDecoderBlockEntity)this).method_10997(), this.method_11016());
    protected final MultiCachingSender writeSender = new MultiCachingSender(() -> ((AddressDecoderBlockEntity)this).method_10997(), this.method_11016(), this::validAddress);
    private final ConfigEntry lookupEntry = new SimpleEntry("Address");
    private final WritePort lookupWritePort = this::receiveLookup;
    private final WritePort dataWritePort = this::receiveData;
    private final SimpleReadPort dataOutPort = new SimpleReadPort(new SimpleEntry("Data out"), this.writeSender::send);
    private final DirectReadPort dataReadPort = new DirectReadPort(new SimpleEntry("Data read"), this::readViaLookup, this.readSender::send);
    protected final NeepBusConfig config = NeepBusConfig.builder(this::sync).applyChanges(this).input(this.lookupEntry, this.lookupWritePort).input(new SimpleEntry("Data"), this.dataWritePort).output(this.dataOutPort.entry(), this.dataOutPort).output(this.dataReadPort.entry(), this.dataReadPort).build();
    private int addressInt;

    public AddressDecoderBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.maxOutputs = 64;
    }

    protected boolean validAddress(String address) {
        Integer integer = Ints.tryParse((String)address);
        return integer != null && integer >= 0 && integer < this.maxOutputs;
    }

    private void receiveLookup(DataVariant addressInt) {
        this.addressInt = addressInt.intValue();
        this.dataOutPort.entry().setAddress(String.valueOf(this.addressInt));
        this.dataReadPort.send();
    }

    private DataVariant readViaLookup() {
        return this.readSender.read(this.dataOutPort.entry().getAddress());
    }

    private void receiveData(DataVariant data) {
        if (this.addressInt >= 0 && this.addressInt < this.maxOutputs) {
            this.dataOutPort.entry().setAddress(String.valueOf(this.addressInt));
            this.dataOutPort.send(data);
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.config.writeNbt(nbt);
        this.dataOutPort.writeNbt(nbt);
        nbt.method_10569("address_int", this.addressInt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt);
        this.dataOutPort.writeNbt(nbt);
        this.addressInt = nbt.method_10550("address_int");
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    public void invalidate() {
        this.readSender.invalidate();
    }
}

