/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.block.entity.SignalIntegrator;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.DirectReadPort;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.WritePort;
import com.neep.neepbus.util.message.DataVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class IntegratorBlockEntity
extends SyncableBlockEntity
implements ConfigProvider,
SignalIntegrator {
    private final CachingSender sender;
    private final ConfigEntry inputEntry;
    private final ConfigEntry clearEntry;
    private final WritePort input;
    private final WritePort clear;
    private final DirectReadPort output;
    private final NeepBusConfig config;
    private float integral;
    private int interval;
    private float timeFactor;
    private float inputValue;

    public IntegratorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.sender = new CachingSender(() -> ((IntegratorBlockEntity)this).method_10997(), this.field_11867);
        this.inputEntry = new SimpleEntry("Input");
        this.clearEntry = new SimpleEntry("Clear");
        this.input = this::receive;
        this.clear = this::clear;
        this.output = new DirectReadPort(new SimpleEntry("Integral"), () -> DataVariant.of(this.integral), this.sender::send);
        this.config = NeepBusConfig.builder(this::sync).input(this.inputEntry, this.input).input(this.clearEntry, this.clear).output(this.output.entry(), this.output).applyChanges(this).build();
        this.interval = 5;
        this.timeFactor = 1.0f;
    }

    private void receive(DataVariant data) {
        this.inputValue = data.floatValue();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.config.writeNbt(nbt);
        nbt.method_10548("integral", this.integral);
        nbt.method_10569("interval", this.interval);
        nbt.method_10548("time_factor", this.timeFactor);
        nbt.method_10548("input", this.inputValue);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt);
        this.integral = nbt.method_10583("integral");
        this.interval = nbt.method_10550("interval");
        this.timeFactor = nbt.method_10583("time_factor");
        this.inputValue = nbt.method_10583("input");
    }

    public void invalidate() {
        this.sender.invalidate();
    }

    public void serverTick() {
        if (this.field_11863.method_8510() % (long)this.interval == 0L) {
            this.integral += this.inputValue * (float)this.interval * this.timeFactor;
            this.output.send();
        }
    }

    @Override
    public void setValues(int loopTime, float timeFactor) {
        this.interval = loopTime;
        this.timeFactor = timeFactor;
        this.sync();
    }

    @Override
    public int loopTime() {
        return this.interval;
    }

    @Override
    public float timeFactor() {
        return this.timeFactor;
    }

    public void setStored(float value) {
        this.integral = 0.0f;
        this.sync();
    }

    private void clear(DataVariant f) {
        this.integral = 0.0f;
    }
}

