/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.block.entity;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.neepbus.block.entity.ConfigProvider;
import com.neep.neepbus.block.entity.MovementControl;
import com.neep.neepbus.input.InputInterceptor;
import com.neep.neepbus.util.CachingSender;
import com.neep.neepbus.util.NeepBusConfig;
import com.neep.neepbus.util.SimpleEntry;
import com.neep.neepbus.util.SimpleReadPort;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.util.EnumMap;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;

public class MovementControlBlockEntity
extends SyncableBlockEntity
implements ConfigProvider,
InputInterceptor,
MovementControl {
    public static final class_2960 ID = new class_2960("neepmeat", "movement_control");
    private final CachingSender sender;
    private final SimpleReadPort forwards;
    private final SimpleReadPort backwards;
    private final SimpleReadPort left;
    private final SimpleReadPort right;
    private final SimpleReadPort up;
    private final SimpleReadPort down;
    private final EnumMap<InputInterceptor.Movement, Entry> sendMap;
    private final NeepBusConfig config;

    public MovementControlBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.sender = new CachingSender(() -> ((MovementControlBlockEntity)this).method_10997(), this.field_11867);
        this.forwards = new SimpleReadPort(new SimpleEntry("Forwards"), this.sender::send);
        this.backwards = new SimpleReadPort(new SimpleEntry("Backwards"), this.sender::send);
        this.left = new SimpleReadPort(new SimpleEntry("Left"), this.sender::send);
        this.right = new SimpleReadPort(new SimpleEntry("Right"), this.sender::send);
        this.up = new SimpleReadPort(new SimpleEntry("Up"), this.sender::send);
        this.down = new SimpleReadPort(new SimpleEntry("Down"), this.sender::send);
        this.sendMap = (EnumMap)class_156.method_654(new EnumMap(InputInterceptor.Movement.class), m -> {
            m.put(InputInterceptor.Movement.FORWARDS, new Entry(this.forwards));
            m.put(InputInterceptor.Movement.BACKWARDS, new Entry(this.backwards));
            m.put(InputInterceptor.Movement.LEFT, new Entry(this.left));
            m.put(InputInterceptor.Movement.RIGHT, new Entry(this.right));
            m.put(InputInterceptor.Movement.UP, new Entry(this.up));
            m.put(InputInterceptor.Movement.DOWN, new Entry(this.down));
        });
        this.config = NeepBusConfig.builder(this::sync).output(this.forwards.entry(), this.forwards).output(this.backwards.entry(), this.backwards).output(this.left.entry(), this.left).output(this.right.entry(), this.right).output(this.up.entry(), this.up).output(this.down.entry(), this.down).build();
    }

    @Override
    public NeepBusConfig getConfig() {
        return this.config;
    }

    @Override
    public void movementInput(class_1657 source, boolean action, InputInterceptor.Movement key) {
        Entry entry = this.sendMap.get((Object)key);
        if (action) {
            entry.send();
        } else {
            entry.reset();
        }
    }

    @Override
    public class_2960 handlerId() {
        return ID;
    }

    @Override
    public void close(class_1657 source) {
        for (Entry entry : this.sendMap.values()) {
            entry.reset();
        }
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.config.writeNbt(nbt);
        class_2499 list = new class_2499();
        for (Entry entry : this.sendMap.values()) {
            list.add((Object)class_2494.method_23244((float)entry.value));
        }
        nbt.method_10566("values", (class_2520)list);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.config.readNbt(nbt);
        class_2499 list = nbt.method_10554("values", 5);
        int i = 0;
        for (Entry entry : this.sendMap.values()) {
            entry.value = list.method_10604(i);
            ++i;
        }
    }

    public void invalidate() {
        this.sender.invalidate();
    }

    @Override
    public FloatList getValues() {
        return new FloatArrayList(this.sendMap.values().stream().map(e -> Float.valueOf(e.value)).toList());
    }

    @Override
    public void setValues(FloatList list) {
        int i = 0;
        for (Entry entry : this.sendMap.values()) {
            entry.value = list.getFloat(i);
            ++i;
        }
        this.method_5431();
    }

    private static class Entry {
        public SimpleReadPort port;
        public float value = 1.0f;

        public Entry(SimpleReadPort port) {
            this.port = port;
        }

        public void send() {
            this.port.send(this.value);
        }

        public void reset() {
            this.port.send(0.0);
        }
    }
}

