/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.input;

import com.google.common.base.Suppliers;
import com.neep.meatlib.client.event.KeyboardEvents;
import com.neep.neepbus.client.input.InputInterceptorHandler;
import com.neep.neepbus.input.InputInterceptor;
import com.neep.neepbus.input.InputInterceptors;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class InputInterceptorsClient {
    private static final Map<class_2960, InputInterceptorHandler.Factory<?>> OVERLAYS = new HashMap();
    private static boolean ACTIVE = false;
    @Nullable
    private static InputInterceptorHandler HANDLER = null;
    private static final Supplier<List<class_304>> KEYS_TO_CANCEL = Suppliers.memoize(() -> {
        class_310 client = class_310.method_1551();
        class_315 options = client.field_1690;
        return List.of(options.field_1904, options.field_1886, options.field_1894, options.field_1881, options.field_1913, options.field_1849, options.field_1903, options.field_1832);
    });

    public static <T extends InputInterceptorHandler> InputInterceptorHandler.Factory<T> register(class_2960 id, InputInterceptorHandler.Factory<T> factory) {
        OVERLAYS.put(id, factory);
        return factory;
    }

    public static void init() {
        InputInterceptors.ACTIVATE.receiver(EnvType.CLIENT, InputInterceptorsClient::setActive);
        KeyboardEvents.PRE_INPUT.register((window, key, scancode, action, modifiers) -> {
            if (ACTIVE) {
                if (key == 256) {
                    InputInterceptorsClient.signalDeactivate();
                    return true;
                }
                InputInterceptor.Movement movement = InputInterceptorsClient.getMovement(key, scancode);
                if (movement != null) {
                    if (action == 1 || action == 0) {
                        InputInterceptors.EVENT.emitter(null).apply(action != 0, key, movement);
                    }
                    return true;
                }
            }
            return false;
        });
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            if (HANDLER != null) {
                HANDLER.render(drawContext, tickDelta);
            }
        });
        WorldRenderEvents.BLOCK_OUTLINE.register((worldRenderContext, blockOutlineContext) -> {
            if (HANDLER != null) {
                return HANDLER.onRenderOutline(worldRenderContext, blockOutlineContext);
            }
            return true;
        });
    }

    @Nullable
    private static InputInterceptor.Movement getMovement(int keycode, int scancode) {
        class_310 client = class_310.method_1551();
        class_315 options = client.field_1690;
        if (options.field_1894.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.FORWARDS;
        }
        if (options.field_1881.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.BACKWARDS;
        }
        if (options.field_1913.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.LEFT;
        }
        if (options.field_1849.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.RIGHT;
        }
        if (options.field_1903.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.UP;
        }
        if (options.field_1832.method_1417(keycode, scancode)) {
            return InputInterceptor.Movement.DOWN;
        }
        return null;
    }

    private static void setActive(boolean active, @Nullable class_2960 id) {
        ACTIVE = active;
        if (ACTIVE) {
            for (class_304 binding : KEYS_TO_CANCEL.get()) {
                binding.method_23481(false);
            }
        }
        if (id != null) {
            InputInterceptorHandler.Factory<?> factory = OVERLAYS.get(id);
            if (factory != null) {
                HANDLER = factory.create();
            }
        } else {
            HANDLER = null;
        }
    }

    public static boolean isActive() {
        return ACTIVE;
    }

    public static void signalDeactivate() {
        if (HANDLER != null && HANDLER.acceptScreen(class_310.method_1551().field_1755)) {
            class_310.method_1551().field_1724.method_7346();
        }
        InputInterceptors.ACTIVATE.emitter(null).apply(false, null);
    }

    @Nullable
    public static InputInterceptorHandler currentHandler() {
        return HANDLER;
    }
}

