/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.neep.neepbus.block.SlantedSliderBlock;
import com.neep.neepbus.block.SliderBlock;
import com.neep.neepbus.block.entity.SliderBlockEntity;
import com.neep.neepmeat.client.NMExtraModels;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2738;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_7833;
import org.joml.Quaternionf;

public class LinearLeverInstance
extends BlockEntityInstance<SliderBlockEntity>
implements DynamicInstance {
    private float lerpOffset = 0.0f;
    private final ModelData handle;

    public LinearLeverInstance(MaterialManager materialManager, SliderBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.handle = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.LINEAR_LEVER_HANDLE).createInstance();
    }

    protected void remove() {
        this.handle.delete();
    }

    public void beginFrame() {
        float f = 0.625f * LinearLeverInstance.clamp((((SliderBlockEntity)this.blockEntity).getValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()) / (((SliderBlockEntity)this.blockEntity).getMaxValue() - ((SliderBlockEntity)this.blockEntity).getMinValue()), 0.0f, 1.0f);
        this.lerpOffset = class_3532.method_16439((float)0.4f, (float)this.lerpOffset, (float)f);
        if (this.blockState.method_26204() instanceof SliderBlock) {
            Quaternionf facing = this.rotateThing((class_2350)this.blockState.method_11654((class_2769)class_2341.field_11177), (class_2738)this.blockState.method_11654((class_2769)class_2341.field_11007));
            ((ModelData)((ModelData)this.handle.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(facing).translate(0.0, 0.0, (double)this.lerpOffset).unCentre();
        } else if (this.blockState.method_26204() instanceof SlantedSliderBlock) {
            Quaternionf facing = this.rotateSlanted((class_2350)this.blockState.method_11654((class_2769)SlantedSliderBlock.field_11177), (SlantedSliderBlock.Attachment)((Object)this.blockState.method_11654(SlantedSliderBlock.FACE)));
            ((ModelData)((ModelData)((ModelData)((ModelData)this.handle.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).multiply(facing).unCentre()).translate(0.0, 0.0625, 0.0).rotate(class_2350.field_11039, 0.7853982f)).translate(0.0, 0.0, 0.25).translate(0.0, 0.0, (double)this.lerpOffset);
        }
    }

    public void updateLight() {
        this.relight(this.getWorldPosition(), new FlatLit[]{this.handle});
    }

    private Quaternionf rotateThing(class_2350 horFacing, class_2738 face) {
        if (face == class_2738.field_12471) {
            return switch (horFacing) {
                case class_2350.field_11043 -> LinearLeverInstance.euler(-90.0f, 0.0f);
                case class_2350.field_11035 -> LinearLeverInstance.euler(-90.0f, 180.0f);
                case class_2350.field_11034 -> LinearLeverInstance.euler(-90.0f, -90.0f);
                default -> LinearLeverInstance.euler(-90.0f, 90.0f);
            };
        }
        if (face == class_2738.field_12475) {
            return switch (horFacing) {
                case class_2350.field_11043 -> class_7833.field_40716.rotationDegrees(180.0f);
                case class_2350.field_11035 -> new Quaternionf();
                case class_2350.field_11034 -> LinearLeverInstance.euler(0.0f, 90.0f);
                default -> LinearLeverInstance.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverInstance.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverInstance.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverInstance.euler(180.0f, -90.0f);
            default -> LinearLeverInstance.euler(180.0f, 90.0f);
        };
    }

    private Quaternionf rotateSlanted(class_2350 horFacing, SlantedSliderBlock.Attachment face) {
        if (face == SlantedSliderBlock.Attachment.FLOOR) {
            return switch (horFacing) {
                case class_2350.field_11043 -> class_7833.field_40716.rotationDegrees(180.0f);
                case class_2350.field_11035 -> new Quaternionf();
                case class_2350.field_11034 -> LinearLeverInstance.euler(0.0f, 90.0f);
                default -> LinearLeverInstance.euler(0.0f, -90.0f);
            };
        }
        return switch (horFacing) {
            case class_2350.field_11043 -> LinearLeverInstance.euler(180.0f, 0.0f);
            case class_2350.field_11035 -> LinearLeverInstance.euler(180.0f, 180.0f);
            case class_2350.field_11034 -> LinearLeverInstance.euler(180.0f, -90.0f);
            default -> LinearLeverInstance.euler(180.0f, 90.0f);
        };
    }

    public static float clamp(float value, float min, float max) {
        if (Float.isNaN(value)) {
            return min;
        }
        return value < min ? min : Math.min(value, max);
    }

    private static Quaternionf euler(float xDeg, float yDeg) {
        return new Quaternionf().rotateZYX(0.0f, yDeg * ((float)Math.PI / 180), xDeg * ((float)Math.PI / 180));
    }
}

