/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.client.screen;

import com.neep.meatlib.client.screen.widget.FloatNumberTextField;
import com.neep.meatlib.client.screen.widget.ParentWidget;
import com.neep.neepbus.screen.RangeConfigHandler;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.client.screen.util.Background;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class RangeConfigWidget
extends ParentWidget {
    private final RangeConfigHandler handler;
    private final List<TextField> textFields = new ObjectArrayList();

    public RangeConfigWidget(int x, int y, int w, int h, RangeConfigHandler handler) {
        super(x, y, w, h);
        this.handler = handler;
        handler.updateParamsS2C.receiver(this::updateParams);
        this.addTextField(new TextField(this.textRenderer, x, y, w, 8, class_2561.method_30163((String)"Value: ")));
        this.addTextField(new TextField(this.textRenderer, x, y, w, 8, class_2561.method_30163((String)"Min: ")));
        this.addTextField(new TextField(this.textRenderer, x, y, w, 8, class_2561.method_30163((String)"Max: ")));
    }

    protected <T extends TextField> T addTextField(T t) {
        this.textFields.add(t);
        return t;
    }

    void updateParams(List<Float> integers) {
        if (integers.size() != this.textFields.size()) {
            NeepMeat.LOGGER.error("RangeConfigWidget: Incorrect number of integers received");
            return;
        }
        for (int i = 0; i < integers.size(); ++i) {
            TextField field = this.textFields.get(i);
            field.setNumberText(integers.get(i));
            field.dirty = false;
        }
    }

    @Override
    public void init() {
        super.init();
        Background background = new Background(this.x, this.y, this.w, this.h, 6);
        this.addChild(background);
        int yOff = this.y;
        for (TextField field : this.textFields) {
            this.addChild(field);
            field.setDims(this.x, yOff, this.w(), field.h());
            field.drawFancyBackground(false);
            yOff += field.h() + 1;
        }
        this.h = yOff - this.y;
        background.setH(this.h);
    }

    @Override
    public void tick() {
    }

    public void update() {
        try {
            FloatArrayList list = new FloatArrayList(this.textFields.size());
            for (TextField field : this.textFields) {
                float parsed = field.parse();
                list.add(parsed);
            }
            this.handler.receiveParamsC2S.emitter().update((List<Float>)list);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Override
    public void method_37020(class_6382 builder) {
    }

    @Override
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void setW(int w) {
        this.w = w;
    }

    protected class TextField
    extends FloatNumberTextField {
        public TextField(class_327 textRenderer, int x, int y, int width, int height, class_2561 prefix) {
            super(textRenderer, x, y, width, height, prefix, c -> RangeConfigWidget.this.update(), -3.4028235E38f, Float.MAX_VALUE, 1.0f, 10.0f);
        }
    }
}

