/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepbus.screen;

import com.neep.meatlib.api.network.ChannelFormat;
import com.neep.meatlib.api.network.ParamCodec;
import com.neep.meatlib.api.network.RecordParamCodec;
import com.neep.meatlib.network.ChannelManager;
import com.neep.meatlib.screen.WidgetHandler;
import com.neep.neepbus.screen.NeepBusConfigScreenHandler;
import com.neep.neepbus.util.ConfigEntry;
import com.neep.neepbus.util.NeepBusConfig;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class AddressConfigHandler
implements WidgetHandler {
    public static final ParamCodec<List<SyncEntry>> SYNC_ENTRY_CODEC = ParamCodec.list(SyncEntry.PARAM_CODEC);
    public static final ChannelFormat<NeepBusConfigScreenHandler.UpdateEntries> SYNC_ENTRIES_FORMAT = ChannelFormat.builder(NeepBusConfigScreenHandler.UpdateEntries.class).param(SYNC_ENTRY_CODEC).build();
    public final ChannelManager<NeepBusConfigScreenHandler.OnAddressChange> addressChangeC2S;
    public final ChannelManager<NeepBusConfigScreenHandler.UpdateEntries> updateInputsS2C;
    public final ChannelManager<NeepBusConfigScreenHandler.UpdateEntries> updateOutputsS2C;
    public List<SyncEntry> outputs = List.of();
    public List<SyncEntry> inputs = List.of();
    protected final NeepBusConfig config;

    public AddressConfigHandler(NeepBusConfig config, class_1657 player) {
        this.config = config;
        this.addressChangeC2S = ChannelManager.create(new class_2960("neepmeat", "address_change"), ChannelFormat.builder(NeepBusConfigScreenHandler.OnAddressChange.class).param(ParamCodec.BOOLEAN).param(ParamCodec.INT).param(ParamCodec.STRING).build(), player);
        this.updateInputsS2C = ChannelManager.create(new class_2960("neepmeat", "update_entries_inputs"), SYNC_ENTRIES_FORMAT, player);
        this.updateOutputsS2C = ChannelManager.create(new class_2960("neepmeat", "update_entries_outputs"), SYNC_ENTRIES_FORMAT, player);
        this.addressChangeC2S.receiver(this::onAddressChange);
        this.updateInputsS2C.receiver(this::receiveInputs);
        this.updateOutputsS2C.receiver(this::receiveOutputs);
    }

    public void receiveOpeningData(class_2540 buf) {
        this.receiveInputs(SYNC_ENTRY_CODEC.decode(buf));
        this.receiveOutputs(SYNC_ENTRY_CODEC.decode(buf));
    }

    private void receiveInputs(List<SyncEntry> list) {
        this.inputs = list;
    }

    private void receiveOutputs(List<SyncEntry> list) {
        this.outputs = list;
    }

    private void onAddressChange(boolean output, int idx, String newAddress) {
        if (this.config != null) {
            if (!output) {
                this.config.getInputs().get(idx).setAddress(newAddress);
            } else {
                this.config.getOutputs().get(idx).setAddress(newAddress);
            }
            this.config.applyChanges();
        }
    }

    @Override
    public void close() {
        this.addressChangeC2S.close();
        this.updateInputsS2C.close();
        this.updateOutputsS2C.close();
    }

    @Override
    public void sendUpdates() {
        if (this.config != null) {
            this.updateInputsS2C.emitter().update(this.config.getInputs().stream().map(SyncEntry::of).toList());
            this.updateOutputsS2C.emitter().update(this.config.getOutputs().stream().map(SyncEntry::of).toList());
        }
    }

    public NeepBusConfig config() {
        return this.config;
    }

    public record SyncEntry(String name, String address) {
        public static final ParamCodec<SyncEntry> PARAM_CODEC = RecordParamCodec.builder(SyncEntry.class).param(ParamCodec.STRING).param(ParamCodec.STRING).build();

        public static SyncEntry of(ConfigEntry entry) {
            return new SyncEntry(entry.getName(), entry.getAddress());
        }
    }
}

