/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.big_block;

import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.neep.neepmeat.api.big_block.BigBlockStructureEntity;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Collection;
import java.util.Map;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;

public class BigBlockPattern {
    protected Map<class_2382, BlockStateProvider> stateProviderMap = Maps.newHashMap();
    protected Multimap<class_2382, BlockApiLookup<?, ?>> apiMap = Multimaps.newSetMultimap((Map)Maps.newHashMap(), Sets::newHashSet);

    public <T extends BigBlockPattern> T oddCylinder(int radius, int startHeight, int endHeight, BlockStateProvider state) {
        return this.oddCylinder(class_2382.field_11176, radius, startHeight, endHeight, state);
    }

    public <T extends BigBlockPattern> T oddCylinder(class_2382 origin, int radius, int startHeight, int endHeight, BlockStateProvider state) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = startHeight; k <= endHeight; ++k) {
                    this.set(origin.method_10263() + i, origin.method_10264() + k, origin.method_10260() + j, state);
                }
            }
        }
        return (T)this;
    }

    public <T extends BigBlockPattern> T range(int startX, int startY, int startZ, int endX, int endY, int endZ, BlockStateProvider state) {
        class_2338.method_10097((class_2338)new class_2338(startX, startY, startZ), (class_2338)new class_2338(endX, endY, endZ)).forEach(mutable -> this.set((class_2382)mutable.method_10062(), state));
        return (T)this;
    }

    public static BigBlockPattern makeOddCylinder(int radius, int startHeight, int endHeight, class_2680 state) {
        return BigBlockPattern.makeOddCylinder(class_2382.field_11176, radius, startHeight, endHeight, state);
    }

    public static BigBlockPattern makeOddCylinder(class_2382 origin, int radius, int startHeight, int endHeight, class_2680 state) {
        return new BigBlockPattern().oddCylinder(origin, radius, startHeight, endHeight, () -> state);
    }

    public static BigBlockPattern makeRange(int startX, int startY, int startZ, int endX, int endY, int endZ, class_2680 state) {
        return new BigBlockPattern().range(startX, startY, startZ, endX, endY, endZ, () -> state);
    }

    public <P extends BigBlockPattern> P set(int x, int y, int z, class_2680 state) {
        return this.set(new class_2382(x, y, z), () -> state);
    }

    public <P extends BigBlockPattern> P set(int x, int y, int z, BlockStateProvider state) {
        return this.set(new class_2382(x, y, z), state);
    }

    public <P extends BigBlockPattern> P set(class_2382 pos, BlockStateProvider state) {
        this.stateProviderMap.put(pos, state);
        return (P)this;
    }

    public <P extends BigBlockPattern, T, C> P enableApi(int x, int y, int z, BlockApiLookup<T, C> lookup) {
        this.apiMap.put((Object)new class_2382(x, y, z), lookup);
        return (P)this;
    }

    public <P extends BigBlockPattern> P remove(class_2382 pos) {
        this.stateProviderMap.remove(pos);
        return (P)this;
    }

    public Collection<class_2382> iterable() {
        return this.stateProviderMap.keySet();
    }

    public Int2ObjectMap<class_2382> encode() {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap();
        int i = 1;
        for (class_2382 offset : this.iterable()) {
            if (offset.equals((Object)class_2382.field_11176)) continue;
            map.put(i, (Object)offset);
            ++i;
        }
        map.put(0, (Object)class_2382.field_11176);
        return map;
    }

    public Iterable<Pair<class_2382, class_2680>> entries() {
        return this.stateProviderMap.entrySet().stream().map(e -> Pair.of((Object)((class_2382)e.getKey()), (Object)((BlockStateProvider)e.getValue()).get()))::iterator;
    }

    public void placeBlocks(class_1937 world, class_2338 origin, class_2338 controller) {
        class_2338.class_2339 mutable = origin.method_25503();
        this.stateProviderMap.forEach((offset, provider) -> {
            mutable.method_35831((class_2382)origin, offset);
            if (mutable.equals((Object)controller)) {
                return;
            }
            world.method_8652((class_2338)mutable, provider.get(), 2);
            this.postProcessBlock(world, (class_2382)offset, (class_2338)mutable, controller, provider.get());
        });
    }

    public Collection<BlockApiLookup<?, ?>> getApi(class_2382 offset) {
        return this.apiMap.get((Object)offset);
    }

    protected void postProcessBlock(class_1937 world, class_2382 offset, class_2338 pos, class_2338 controller, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BigBlockStructureEntity) {
            BigBlockStructureEntity be = (BigBlockStructureEntity)class_25862;
            be.setController(controller);
            this.apiMap.get((Object)offset).forEach(be::enableApi);
            world.method_8408(pos, state.method_26204());
        }
    }

    public BigBlockPattern rotateY(float degrees) {
        BigBlockPattern newVolume = new BigBlockPattern();
        double s = Math.round(Math.sin(Math.toRadians(degrees)));
        double c = Math.round(Math.cos(Math.toRadians(degrees)));
        this.stateProviderMap.forEach((offset, state) -> {
            int newX = (int)Math.round((double)offset.method_10263() * c - (double)offset.method_10260() * s);
            int newZ = (int)Math.round((double)offset.method_10263() * s + (double)offset.method_10260() * c);
            newVolume.set(newX, offset.method_10264(), newZ, (BlockStateProvider)state);
        });
        this.apiMap.forEach((offset, api) -> {
            int newX = (int)Math.round((double)offset.method_10263() * c - (double)offset.method_10260() * s);
            int newZ = (int)Math.round((double)offset.method_10263() * s + (double)offset.method_10260() * c);
            newVolume.enableApi(newX, offset.method_10264(), newZ, (BlockApiLookup)api);
        });
        return newVolume;
    }

    public BigBlockPattern mirrorY() {
        BigBlockPattern newVolume = new BigBlockPattern();
        this.stateProviderMap.forEach((offset, state) -> newVolume.set(offset.method_10263(), -offset.method_10264(), offset.method_10260(), (BlockStateProvider)state));
        this.apiMap.forEach((offset, api) -> newVolume.enableApi(offset.method_10263(), -offset.method_10264(), offset.method_10260(), (BlockApiLookup)api));
        return newVolume;
    }

    public class_265 toVoxelShape() {
        return this.unSimplifiedShape().method_1097();
    }

    public class_265 unSimplifiedShape() {
        class_265 shape = class_259.method_1073();
        for (class_2382 vec : this.iterable()) {
            shape = class_259.method_1082((class_265)shape, (class_265)class_259.method_1081((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260(), (double)(vec.method_10263() + 1), (double)(vec.method_10264() + 1), (double)(vec.method_10260() + 1)), (class_247)class_247.field_1366);
        }
        return shape;
    }

    public class_238 toBox(class_2338 origin) {
        class_238 box = new class_238(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (class_2382 vec : this.iterable()) {
            box = box.method_991(new class_238((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260(), (double)(vec.method_10263() + 1), (double)(vec.method_10264() + 1), (double)(vec.method_10260() + 1)));
        }
        return box.method_996(origin);
    }

    @FunctionalInterface
    public static interface BlockStateProvider {
        public class_2680 get();
    }
}

