/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine;

import com.google.common.util.concurrent.AtomicDouble;

public record PropertyValue(Function function, float value) {
    public PropertyValue(float value) {
        this(Function.AVERAGE, value);
    }

    public void apply(AtomicDouble atomicDouble, int count) {
        switch (this.function) {
            case ADD: {
                atomicDouble.addAndGet((double)this.value);
                break;
            }
            case AVERAGE: {
                atomicDouble.addAndGet((double)(this.value / (float)count));
            }
        }
    }

    public float apply(float f, int count) {
        return switch (this.function) {
            default -> throw new IncompatibleClassChangeError();
            case Function.ADD -> f + this.value;
            case Function.AVERAGE -> f + this.value / (float)count;
        };
    }

    public static enum Function {
        ADD("added"),
        AVERAGE("averaged");

        public final String name;

        private Function(String name) {
            this.name = name;
        }

        public boolean average() {
            return this == AVERAGE;
        }
    }
}

