/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.api.live_machine;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.neep.neepmeat.api.live_machine.Formatter;
import com.neep.neepmeat.api.live_machine.PropertyValue;
import com.neep.neepmeat.api.live_machine.StructurePropertyFormatter;
import com.neep.neepmeat.api.processing.PowerUtils;
import java.util.EnumMap;

public enum StructureProperty implements Formatter
{
    FAULT_TOLERANCE(0.0f, StructurePropertyFormatter.DEFAULT_FLOAT_FORMAT::format),
    SPEED(1.0f, StructurePropertyFormatter.DEFAULT_FLOAT_FORMAT::format),
    SELF_REPAIR(0.0f, StructurePropertyFormatter::formatRepair),
    MAX_POWER(0.0f, v -> PowerUtils.POWER_FORMAT.format(v) + PowerUtils.POWER_UNIT.getString()),
    MASS(1.0f, StructurePropertyFormatter.DEFAULT_FLOAT_FORMAT::format);

    public static final Codec<StructureProperty> CODEC;
    public static final EnumMap<StructureProperty, PropertyValue> EMPTY;
    private final float def;
    private final StructurePropertyFormatter formatter;

    private StructureProperty(float def, StructurePropertyFormatter formatter) {
        this.def = def;
        this.formatter = formatter;
    }

    public float defaultValue() {
        return this.def;
    }

    @Override
    public String format(PropertyValue value) {
        return this.formatter.format(value.value());
    }

    static {
        CODEC = Codec.STRING.comapFlatMap(id -> DataResult.success((Object)StructureProperty.valueOf(StructureProperty.class, id)), Enum::name).stable();
        EMPTY = new EnumMap(StructureProperty.class);
    }
}

