/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.neep.meatlib.block.BaseBlock;
import com.neep.meatlib.item.ItemSettings;
import com.neep.meatlib.registry.RegistrationContext;
import java.util.Map;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2773;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CautionTapeBlock
extends BaseBlock {
    public static final class_2754<class_2773> CONNECTION_NORTH = class_2741.field_12495;
    public static final class_2754<class_2773> CONNECTION_EAST = class_2741.field_12523;
    public static final class_2754<class_2773> CONNECTION_SOUTH = class_2741.field_12551;
    public static final class_2754<class_2773> CONNECTION_WEST = class_2741.field_12504;
    public static final Map<class_2350, class_2754<class_2773>> DIRECTION_TO_WIRE_CONNECTION_PROPERTY = Maps.newEnumMap((Map)ImmutableMap.of((Object)class_2350.field_11043, CONNECTION_NORTH, (Object)class_2350.field_11034, CONNECTION_EAST, (Object)class_2350.field_11035, CONNECTION_SOUTH, (Object)class_2350.field_11039, CONNECTION_WEST));
    public class_2680 dotState;

    public CautionTapeBlock(RegistrationContext ctx, ItemSettings itemSettings, class_4970.class_2251 settings) {
        super(ctx, itemSettings, settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(CONNECTION_NORTH, (Comparable)class_2773.field_12687)).method_11657(CONNECTION_EAST, (Comparable)class_2773.field_12687)).method_11657(CONNECTION_SOUTH, (Comparable)class_2773.field_12687)).method_11657(CONNECTION_WEST, (Comparable)class_2773.field_12687));
        this.dotState = (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(CONNECTION_NORTH, (Comparable)class_2773.field_12689)).method_11657(CONNECTION_EAST, (Comparable)class_2773.field_12689)).method_11657(CONNECTION_SOUTH, (Comparable)class_2773.field_12689)).method_11657(CONNECTION_WEST, (Comparable)class_2773.field_12689);
    }

    public class_2680 method_9605(class_1750 ctx) {
        return this.getPlacementState((class_1922)ctx.method_8045(), this.dotState, ctx.method_8037());
    }

    private class_2680 getPlacementState(class_1922 world, class_2680 state, class_2338 pos) {
        boolean bl7;
        state = this.getDefaultWireState(world, this.method_9564(), pos);
        if (CautionTapeBlock.isNotConnected(state)) {
            return state;
        }
        boolean north = ((class_2773)state.method_11654(CONNECTION_NORTH)).method_27855();
        boolean east = ((class_2773)state.method_11654(CONNECTION_SOUTH)).method_27855();
        boolean south = ((class_2773)state.method_11654(CONNECTION_EAST)).method_27855();
        boolean west = ((class_2773)state.method_11654(CONNECTION_WEST)).method_27855();
        boolean bl6 = !north && !east;
        boolean bl = bl7 = !south && !west;
        if (!west && bl6) {
            state = (class_2680)state.method_11657(CONNECTION_WEST, (Comparable)class_2773.field_12689);
        }
        if (!south && bl6) {
            state = (class_2680)state.method_11657(CONNECTION_EAST, (Comparable)class_2773.field_12689);
        }
        if (!north && bl7) {
            state = (class_2680)state.method_11657(CONNECTION_NORTH, (Comparable)class_2773.field_12689);
        }
        if (!east && bl7) {
            state = (class_2680)state.method_11657(CONNECTION_SOUTH, (Comparable)class_2773.field_12689);
        }
        return state;
    }

    private class_2680 getDefaultWireState(class_1922 world, class_2680 state, class_2338 pos) {
        boolean bl = !world.method_8320(pos.method_10084()).method_26212(world, pos);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            if (((class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855()) continue;
            class_2773 wireConnection = this.getRenderConnectionType(world, pos, direction, bl);
            state = (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)wireConnection);
        }
        return state;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction == class_2350.field_11033) {
            return state;
        }
        if (direction == class_2350.field_11036) {
            return this.getPlacementState((class_1922)world, state, pos);
        }
        class_2773 connection = this.getRenderConnectionType((class_1922)world, pos, direction, true);
        if (connection.method_27855() == ((class_2773)state.method_11654((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction))).method_27855() && !CautionTapeBlock.isFullyConnected(state)) {
            return (class_2680)state.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)connection);
        }
        return this.getPlacementState((class_1922)world, (class_2680)this.dotState.method_11657((class_2769)DIRECTION_TO_WIRE_CONNECTION_PROPERTY.get(direction), (Comparable)connection), pos);
    }

    protected static boolean connectsTo(class_2680 state, @Nullable class_2350 dir) {
        return false;
    }

    private class_2773 getRenderConnectionType(class_1922 world, class_2338 pos, class_2350 direction, boolean bl) {
        class_2338 blockPos = pos.method_10093(direction);
        class_2680 blockState = world.method_8320(blockPos);
        if (bl && this.canRunOnTop(world, blockPos, blockState) && CautionTapeBlock.connectsTo(world.method_8320(blockPos.method_10084()), null)) {
            if (blockState.method_26206(world, blockPos, direction.method_10153())) {
                return class_2773.field_12686;
            }
            return class_2773.field_12689;
        }
        if (CautionTapeBlock.connectsTo(blockState, direction)) {
            return class_2773.field_12689;
        }
        return class_2773.field_12687;
    }

    private static boolean isFullyConnected(class_2680 state) {
        return ((class_2773)state.method_11654(CONNECTION_NORTH)).method_27855() && ((class_2773)state.method_11654(CONNECTION_SOUTH)).method_27855() && ((class_2773)state.method_11654(CONNECTION_EAST)).method_27855() && ((class_2773)state.method_11654(CONNECTION_WEST)).method_27855();
    }

    private static boolean isNotConnected(class_2680 state) {
        return !((class_2773)state.method_11654(CONNECTION_NORTH)).method_27855() && !((class_2773)state.method_11654(CONNECTION_SOUTH)).method_27855() && !((class_2773)state.method_11654(CONNECTION_EAST)).method_27855() && !((class_2773)state.method_11654(CONNECTION_WEST)).method_27855();
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_2680 blockState = world.method_8320(blockPos);
        return this.canRunOnTop((class_1922)world, blockPos, blockState);
    }

    private boolean canRunOnTop(class_1922 world, class_2338 pos, class_2680 floor) {
        return floor.method_26206(world, pos, class_2350.field_11036) || floor.method_27852(class_2246.field_10312);
    }

    private void updateNeighbors(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos).method_27852((class_2248)this)) {
            return;
        }
        world.method_8452(pos, (class_2248)this);
        for (class_2350 direction : class_2350.values()) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (oldState.method_27852(state.method_26204()) || world.field_9236) {
            return;
        }
        for (class_2350 direction : class_2350.class_2353.field_11064) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (moved || state.method_27852(newState.method_26204())) {
            return;
        }
        super.method_9536(state, world, pos, newState, moved);
        if (world.field_9236) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            world.method_8452(pos.method_10093(direction), (class_2248)this);
        }
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{CONNECTION_NORTH, CONNECTION_EAST, CONNECTION_SOUTH, CONNECTION_WEST});
    }
}

