/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.hud;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.neep.neepmeat.init.NMItems;
import com.neep.neepmeat.item.CompoundInjectorItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_757;

@Environment(value=EnvType.CLIENT)
public class HUDOverlays {
    public final class_310 client;
    private static final class_2960 INJECTOR_VIGNETTE = new class_2960("neepmeat", "textures/gui/heal_vignette.png");
    private static final class_2960 PYLON_VIGNETTE = new class_2960("neepmeat", "textures/gui/pylon_vignette.png");
    private static double scaledHeight;
    private static double scaledWidth;
    private static float opacity;
    private static int vignetteState;
    protected static int pylonVignetteState;
    protected static float pylonVignetteEnvelope;

    public HUDOverlays(class_310 client) {
        this.client = client;
    }

    public static void renderVignettes(float tickDelta) {
        RenderSystem.setShader(class_757::method_34539);
        class_310 client = class_310.method_1551();
        scaledWidth = client.method_22683().method_4486();
        scaledHeight = client.method_22683().method_4502();
        class_1799 itemStack1 = client.field_1724.method_6047();
        class_1799 itemStack2 = client.field_1724.method_6079();
        for (class_1799 itemStack : ImmutableList.of((Object)itemStack1, (Object)itemStack2)) {
            if (!(itemStack.method_7909() instanceof CompoundInjectorItem) || CompoundInjectorItem.getHealsRemaining(itemStack) != ((CompoundInjectorItem)NMItems.COMPOUND_INJECTOR).getHealsFor()) continue;
            vignetteState = 1;
            break;
        }
        float f = client.method_1534();
        if (vignetteState == 1) {
            opacity = class_3532.method_16439((float)(0.8f * f), (float)opacity, (float)1.0f);
            HUDOverlays.renderOverlay(INJECTOR_VIGNETTE, opacity, 1.1f);
            if ((double)opacity > 0.99) {
                vignetteState = 2;
            }
        }
        if (vignetteState == 2) {
            opacity = class_3532.method_16439((float)(0.1f * f), (float)opacity, (float)0.0f);
            HUDOverlays.renderOverlay(INJECTOR_VIGNETTE, opacity, 1.1f);
            if ((double)opacity < 0.001) {
                vignetteState = 0;
                opacity = 0.0f;
            }
        }
        HUDOverlays.pylonVignette(tickDelta);
    }

    protected static void pylonVignette(float tickDelta) {
        pylonVignetteEnvelope = class_3532.method_16439((float)(0.04f * class_310.method_1551().method_1534()), (float)pylonVignetteEnvelope, (float)(pylonVignetteState == 1 ? 1.0f : 0.0f));
        if (pylonVignetteState == 1 && (double)pylonVignetteEnvelope > 0.9) {
            pylonVignetteState = 0;
        }
        double den = 20.0;
        long a = class_310.method_1551().field_1687.method_8510();
        float sin = (float)Math.sin((double)a / den + (double)tickDelta / den) + 1.0f;
        float cos = (float)Math.cos((double)a / den + (double)tickDelta / den) + 1.0f;
        float scale = class_3532.method_16439((float)(sin / 2.0f), (float)1.3f, (float)1.5f);
        float opacity = pylonVignetteEnvelope * class_3532.method_16439((float)(cos / 2.0f), (float)0.5f, (float)1.0f);
        HUDOverlays.renderOverlay(PYLON_VIGNETTE, opacity, scale);
    }

    public static void startPylonVignette() {
        if (pylonVignetteState == 0) {
            pylonVignetteState = 1;
        }
    }

    private static void renderOverlay(class_2960 texture, float opacity, float scale) {
        double x2;
        double midx = scaledWidth / 2.0;
        double midy = scaledHeight / 2.0;
        double height = scaledHeight * (double)scale;
        double width = scaledWidth * (double)scale;
        double x1 = midx - width / 2.0;
        double x3 = x2 = midx + width / 2.0;
        double x4 = x1;
        double y1 = midy + height / 2.0;
        double y3 = midy - height / 2.0;
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)opacity);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22912(x1, y1, -90.0).method_22913(0.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(x2, y1, -90.0).method_22913(1.0f, 1.0f).method_1344();
        bufferBuilder.method_22912(x3, y3, -90.0).method_22913(1.0f, 0.0f).method_1344();
        bufferBuilder.method_22912(x4, y3, -90.0).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void init() {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> HUDOverlays.renderVignettes(tickDelta));
    }

    static {
        pylonVignetteState = 0;
        pylonVignetteEnvelope = 0.0f;
    }
}

