/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.instance;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.neep.neepmeat.client.NMExtraModels;
import com.neep.neepmeat.machine.live_machine.block.TreeVacuumBlock;
import com.neep.neepmeat.machine.live_machine.block.entity.TreeVacuumBlockEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;

@Environment(value=EnvType.CLIENT)
public class TreeVacuumInstance
extends BlockEntityInstance<TreeVacuumBlockEntity>
implements DynamicInstance {
    private final ModelData lungL;
    private final ModelData lungR;
    private final ModelData plunger;

    public TreeVacuumInstance(MaterialManager materialManager, TreeVacuumBlockEntity blockEntity) {
        super(materialManager, (class_2586)blockEntity);
        this.lungL = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.TREE_VACUUM_LUNG).createInstance();
        this.lungR = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.TREE_VACUUM_LUNG).createInstance();
        this.plunger = (ModelData)materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(NMExtraModels.TREE_VACUUM_PLUNGER).createInstance();
    }

    protected void remove() {
        this.lungL.delete();
        this.lungR.delete();
        this.plunger.delete();
    }

    private float easeOutSine(float x) {
        return class_3532.method_15374((float)(x * (float)Math.PI / 2.0f));
    }

    public void beginFrame() {
        class_2350 facing = (class_2350)((TreeVacuumBlockEntity)this.blockEntity).method_11010().method_11654((class_2769)TreeVacuumBlock.FACING);
        int animationTicks = ((TreeVacuumBlockEntity)this.blockEntity).animationTicks;
        float t = (float)animationTicks - (animationTicks > 0 ? AnimationTickHolder.getPartialTicks() : 0.0f);
        float plungerOffset = t > 7.0f ? this.easeOutSine(1.0f - (t - 7.0f) / 3.0f) : this.easeOutSine(t / 7.0f);
        float tRad = (float)Math.PI * 2 * t / 10.0f + (float)Math.PI;
        float sf = 1.0f + 0.2f * (class_3532.method_15362((float)tRad) + 1.0f) / 2.0f;
        ((ModelData)((ModelData)((ModelData)((ModelData)this.plunger.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateToFace(facing)).unCentre()).translate(0.0, 0.0, (double)(0.4375f * plungerOffset));
        ((ModelData)((ModelData)((ModelData)((ModelData)this.lungL.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateToFace(facing)).unCentre()).translate(-0.125, 0.5, 0.5).scale(sf, 1.0f, sf).translate(0.125, -0.5, -0.5);
        ((ModelData)((ModelData)((ModelData)((ModelData)((ModelData)this.lungR.loadIdentity().translate((class_2382)this.getInstancePosition())).centre()).rotateToFace(facing)).unCentre()).translate(0.8125, 0.0, 0.25).rotate(class_2350.field_11036, (float)Math.PI)).translate(-0.8125, 0.0, -0.25).translate(0.625, 0.0, 0.0).translate(-0.125, 0.5, 0.0).scale(sf, 1.0f, sf).translate(0.125, -0.5, 0.0);
    }

    public void updateLight() {
        this.relight(this.getWorldPosition(), new FlatLit[]{this.lungL, this.lungR, this.plunger});
    }

    public static void initNetwork() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)TreeVacuumBlockEntity.CHANNEL_ID, (client, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            boolean playSound = buf.readBoolean();
            client.execute(() -> {
                class_2586 patt4695$temp = client.field_1687.method_8321(pos);
                if (patt4695$temp instanceof TreeVacuumBlockEntity) {
                    TreeVacuumBlockEntity be = (TreeVacuumBlockEntity)patt4695$temp;
                    be.startAnimation(playSound, (class_1657)client.field_1724);
                }
            });
        });
    }
}

