/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.client.screen.plc.edit;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.neep.neepmeat.client.screen.plc.MonoTextRenderer;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_155;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_7533;

@Environment(value=EnvType.CLIENT)
public class EditBox {
    private final List<LineEntry> lines = Lists.newArrayList();
    private int width;
    private final MonoTextRenderer textRenderer;
    private String text = "";
    private int cursor;
    private int selectionEnd;
    private boolean selecting;
    private int maxLength = Integer.MAX_VALUE;
    private Consumer<String> changeListener = text -> {};
    private Runnable cursorChangeListener = () -> {};
    private final float scale;

    public EditBox(MonoTextRenderer textRenderer, int width, float scale) {
        this.textRenderer = textRenderer;
        this.width = width;
        this.scale = scale;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("Character limit cannot be negative");
        }
        this.maxLength = maxLength;
    }

    public boolean hasMaxLength() {
        return this.maxLength != Integer.MAX_VALUE;
    }

    public void setChangeListener(Consumer<String> changeListener) {
        this.changeListener = changeListener;
    }

    public void setCursorChangeListener(Runnable cursorChangeListener) {
        this.cursorChangeListener = cursorChangeListener;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = this.truncateForReplacement(text);
        this.selectionEnd = this.cursor = this.text.length();
        this.onChange();
    }

    public void replaceSelection(String string) {
        if (!string.isEmpty() || this.hasSelection()) {
            Object string2 = this.truncate(class_155.method_44355((String)string, (boolean)true));
            Substring substring = this.getSelection();
            if (((String)string2).equals("\n") && substring.beginIndex == substring.endIndex) {
                int spaces = 0;
                int index = Math.min(this.text.length() - 1, substring.beginIndex);
                if (index >= 0) {
                    char c = this.text.charAt(index);
                    if (c == '\n' && index > 0) {
                        --index;
                    }
                    int i = index;
                    do {
                        if ((c = this.text.charAt(i)) != '\n') continue;
                        spaces = this.countSpaces(this.text, Math.min(this.text.length() - 1, i + 1));
                        string2 = (String)string2 + " ".repeat(spaces);
                        break;
                    } while (--i > 0);
                }
            }
            this.text = new StringBuilder(this.text).replace(substring.beginIndex, substring.endIndex, (String)string2).toString();
            this.selectionEnd = this.cursor = substring.beginIndex + ((String)string2).length();
            this.onChange();
        }
    }

    private int countSpaces(String string, int startIndex) {
        char c;
        int spaces = 0;
        int i = startIndex;
        do {
            if ((c = this.text.charAt(i)) != ' ') continue;
            ++spaces;
        } while (c == ' ' && ++i < string.length());
        return spaces;
    }

    public void delete(int offset) {
        if (!this.hasSelection()) {
            this.selectionEnd = class_3532.method_15340((int)(this.cursor + offset), (int)0, (int)this.text.length());
        }
        this.replaceSelection("");
    }

    public int getCursor() {
        return this.cursor;
    }

    public void setSelecting(boolean selecting) {
        this.selecting = selecting;
    }

    public Substring getSelection() {
        return new Substring(Math.min(this.selectionEnd, this.cursor), Math.max(this.selectionEnd, this.cursor));
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int absLineToWrapped(int line) {
        for (int i = 0; i < this.lines.size(); ++i) {
            if (this.lines.get(i).lineNum() != line) continue;
            return i;
        }
        return this.lines.size();
    }

    public int getCurrentLineIndex() {
        for (int i = 0; i < this.lines.size(); ++i) {
            Substring substring = this.lines.get(i).substring();
            if (this.cursor < substring.beginIndex || this.cursor > substring.endIndex) continue;
            return i;
        }
        return -1;
    }

    public LineEntry getLine(int index) {
        return this.lines.get(class_3532.method_15340((int)index, (int)0, (int)(this.lines.size() - 1)));
    }

    public void moveCursor(class_7533 movement, int amount) {
        switch (movement) {
            case field_39535: {
                this.cursor = amount;
                break;
            }
            case field_39536: {
                this.cursor += amount;
                break;
            }
            case field_39537: {
                this.cursor = this.text.length() + amount;
            }
        }
        this.cursor = class_3532.method_15340((int)this.cursor, (int)0, (int)this.text.length());
        this.cursorChangeListener.run();
        if (!this.selecting) {
            this.selectionEnd = this.cursor;
        }
    }

    public void moveCursorLine(int offset) {
        if (offset != 0) {
            int i = this.textRenderer.getWidth(this.text.substring(this.getCurrentLine().beginIndex, this.cursor)) + 2;
            Substring substring = this.getOffsetLine(offset);
            int j = this.textRenderer.trimToWidth(this.text.substring(substring.beginIndex, substring.endIndex), i).length();
            this.moveCursor(class_7533.field_39535, substring.beginIndex + j);
        }
    }

    public void moveCursor(double x, double y) {
        int i = class_3532.method_15357((double)x);
        int j = class_3532.method_15357((double)(y / 9.0));
        LineEntry substring = this.lines.get(class_3532.method_15340((int)j, (int)0, (int)Math.max(0, this.lines.size() - 1)));
        int k = this.textRenderer.trimToWidth(this.text.substring(substring.beginIndex(), substring.endIndex()), i).length();
        this.moveCursor(class_7533.field_39535, substring.beginIndex() + k);
    }

    public boolean handleSpecialKey(int keyCode) {
        this.selecting = class_437.method_25442();
        if (class_437.method_25439((int)keyCode)) {
            this.cursor = this.text.length();
            this.selectionEnd = 0;
            return true;
        }
        if (class_437.method_25438((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            return true;
        }
        if (class_437.method_25437((int)keyCode)) {
            this.replaceSelection(class_310.method_1551().field_1774.method_1460());
            return true;
        }
        if (class_437.method_25436((int)keyCode)) {
            class_310.method_1551().field_1774.method_1455(this.getSelectedText());
            this.replaceSelection("");
            return true;
        }
        switch (keyCode) {
            case 257: 
            case 335: {
                this.replaceSelection("\n");
                return true;
            }
            case 259: {
                if (class_437.method_25441()) {
                    Substring substring = this.getPreviousWordAtCursor();
                    this.delete(substring.beginIndex - this.cursor);
                } else {
                    this.delete(-1);
                }
                return true;
            }
            case 261: {
                if (class_437.method_25441()) {
                    Substring substring = this.getNextWordAtCursor();
                    this.delete(substring.beginIndex - this.cursor);
                } else {
                    this.delete(1);
                }
                return true;
            }
            case 262: {
                if (class_437.method_25441()) {
                    Substring substring = this.getNextWordAtCursor();
                    this.moveCursor(class_7533.field_39535, substring.beginIndex);
                } else {
                    this.moveCursor(class_7533.field_39536, 1);
                }
                return true;
            }
            case 263: {
                if (class_437.method_25441()) {
                    Substring substring = this.getPreviousWordAtCursor();
                    this.moveCursor(class_7533.field_39535, substring.beginIndex);
                } else {
                    this.moveCursor(class_7533.field_39536, -1);
                }
                return true;
            }
            case 264: {
                if (!class_437.method_25441()) {
                    this.moveCursorLine(1);
                }
                return true;
            }
            case 265: {
                if (!class_437.method_25441()) {
                    this.moveCursorLine(-1);
                }
                return true;
            }
            case 266: {
                this.moveCursor(class_7533.field_39535, 0);
                return true;
            }
            case 267: {
                this.moveCursor(class_7533.field_39537, 0);
                return true;
            }
            case 268: {
                if (class_437.method_25441()) {
                    this.moveCursor(class_7533.field_39535, 0);
                } else {
                    this.moveCursor(class_7533.field_39535, this.getCurrentLine().beginIndex);
                }
                return true;
            }
            case 269: {
                if (class_437.method_25441()) {
                    this.moveCursor(class_7533.field_39537, 0);
                } else {
                    this.moveCursor(class_7533.field_39535, this.getCurrentLine().endIndex);
                }
                return true;
            }
            case 258: {
                this.replaceSelection("  ");
                return true;
            }
        }
        return false;
    }

    public Iterable<LineEntry> getLines() {
        return this.lines;
    }

    public boolean hasSelection() {
        return this.selectionEnd != this.cursor;
    }

    @VisibleForTesting
    public String getSelectedText() {
        Substring substring = this.getSelection();
        return this.text.substring(substring.beginIndex, substring.endIndex);
    }

    private Substring getCurrentLine() {
        return this.getOffsetLine(0);
    }

    private Substring getOffsetLine(int offsetFromCurrent) {
        int i = this.getCurrentLineIndex();
        if (i < 0) {
            int var10002 = this.cursor;
            throw new IllegalStateException("Cursor is not within text (cursor = " + var10002 + ", length = " + this.text.length() + ")");
        }
        return this.lines.get(class_3532.method_15340((int)(i + offsetFromCurrent), (int)0, (int)(this.lines.size() - 1))).substring();
    }

    @VisibleForTesting
    public Substring getPreviousWordAtCursor() {
        int i;
        if (this.text.isEmpty()) {
            return Substring.EMPTY;
        }
        for (i = class_3532.method_15340((int)this.cursor, (int)0, (int)(this.text.length() - 1)); i > 0 && Character.isWhitespace(this.text.charAt(i - 1)); --i) {
        }
        while (i > 0 && !Character.isWhitespace(this.text.charAt(i - 1))) {
            --i;
        }
        return new Substring(i, this.getWordEndIndex(i));
    }

    @VisibleForTesting
    public Substring getNextWordAtCursor() {
        int i;
        if (this.text.isEmpty()) {
            return Substring.EMPTY;
        }
        for (i = class_3532.method_15340((int)this.cursor, (int)0, (int)(this.text.length() - 1)); i < this.text.length() && !Character.isWhitespace(this.text.charAt(i)); ++i) {
        }
        while (i < this.text.length() && Character.isWhitespace(this.text.charAt(i))) {
            ++i;
        }
        return new Substring(i, this.getWordEndIndex(i));
    }

    private int getWordEndIndex(int startIndex) {
        int i;
        for (i = startIndex; i < this.text.length() && !Character.isWhitespace(this.text.charAt(i)); ++i) {
        }
        return i;
    }

    private void onChange() {
        this.rewrap();
        this.changeListener.accept(this.text);
        this.cursorChangeListener.run();
    }

    private void rewrap() {
        this.lines.clear();
        if (this.text.isEmpty()) {
            this.lines.add(LineEntry.EMPTY);
        } else {
            AtomicInteger numLines = new AtomicInteger(0);
            this.textRenderer.getTextHandler().method_27485(this.text, Math.round((float)this.width / this.scale), class_2583.field_24360, false, (style, start, end) -> {
                boolean wrap;
                boolean bl = wrap = start - 1 >= 0 && this.text.charAt(start - 1) != '\n';
                if (!wrap && start - 1 >= 0) {
                    numLines.incrementAndGet();
                }
                this.lines.add(new LineEntry(start, end, numLines.get(), wrap));
            });
            if (this.text.charAt(this.text.length() - 1) == '\n') {
                this.lines.add(new LineEntry(this.text.length(), this.text.length(), numLines.get(), false));
            }
        }
    }

    private String truncateForReplacement(String value) {
        return this.hasMaxLength() ? class_3544.method_34963((String)value, (int)this.maxLength, (boolean)false) : value;
    }

    private String truncate(String value) {
        if (this.hasMaxLength()) {
            int i = this.maxLength - this.text.length();
            return class_3544.method_34963((String)value, (int)i, (boolean)false);
        }
        return value;
    }

    public void setWidth(int w) {
        this.width = w;
        this.rewrap();
    }

    @Environment(value=EnvType.CLIENT)
    public record Substring(int beginIndex, int endIndex) {
        static final Substring EMPTY = new Substring(0, 0);
    }

    @Environment(value=EnvType.CLIENT)
    public record LineEntry(Substring substring, int lineNum, boolean wrapped) {
        static final LineEntry EMPTY = new LineEntry(Substring.EMPTY, 0, false);

        public LineEntry(int i, int j, int lineNum, boolean wrapped) {
            this(new Substring(i, j), lineNum, wrapped);
        }

        public int endIndex() {
            return this.substring.endIndex;
        }

        public int beginIndex() {
            return this.substring.beginIndex;
        }
    }
}

