/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.guide;

import com.neep.meatlib.larkdown.LarkdownContent;
import com.neep.meatlib.larkdown.LarkdownParser;
import com.neep.meatlib.larkdown.content.BulletLarkdownContent;
import com.neep.meatlib.larkdown.content.CodeLarkdownContent;
import com.neep.meatlib.larkdown.content.HeadingLarkdownContent;
import com.neep.meatlib.larkdown.content.ImageLarkdownContent;
import com.neep.meatlib.larkdown.content.TextLarkdownContent;
import com.neep.meatlib.larkdown.parser.Alignment;
import com.neep.meatlib.larkdown.parser.Format;
import com.neep.neepmeat.guide.article.Article;
import com.neep.neepmeat.guide.article.CenteredTextContent;
import com.neep.neepmeat.guide.article.CodeContent;
import com.neep.neepmeat.guide.article.ImageContent;
import com.neep.neepmeat.guide.article.TextContent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class GuideLarkdownVisitor
implements LarkdownParser.Visitor {
    private final List<Article.Content> contents;
    private final LarkdownParser.Visitor delegate = LarkdownParser.Visitor.builder().type(BulletLarkdownContent.class, this::visit1).type(HeadingLarkdownContent.class, this::visit1).type(TextLarkdownContent.class, this::visit1).type(CodeLarkdownContent.class, this::visit1).type(ImageLarkdownContent.class, this::visit1).build();

    public GuideLarkdownVisitor(List<LarkdownContent> list) {
        this.contents = new ObjectArrayList();
        list.forEach(content -> content.visit(this));
    }

    public void visit1(BulletLarkdownContent content) {
        this.contents.add(new TextContent((class_2561)class_2561.method_30163((String)("- " + content.text())).method_27661()));
    }

    public void visit1(HeadingLarkdownContent content) {
        this.contents.add(new TextContent((class_2561)class_2561.method_30163((String)content.text()).method_27661().method_27692(class_124.field_1067)));
    }

    public void visit1(TextLarkdownContent content) {
        class_5250 mutableText = class_2561.method_43473().method_27661();
        for (TextLarkdownContent.Entry entry : content.entries()) {
            class_2561 text = switch (entry.format()) {
                default -> throw new IncompatibleClassChangeError();
                case Format.NONE -> class_2561.method_30163((String)entry.text());
                case Format.BOLD -> class_2561.method_43470((String)entry.text()).method_27692(class_124.field_1067);
                case Format.ITALIC -> class_2561.method_43470((String)entry.text()).method_27692(class_124.field_1056);
                case Format.CODE -> class_2561.method_43470((String)entry.text()).method_27692(class_124.field_1056);
                case Format.STRIKETHROUGH -> class_2561.method_43470((String)entry.text()).method_27692(class_124.field_1055);
            };
            mutableText.method_10852(text);
        }
        this.contents.add(switch (content.alignment()) {
            case Alignment.CENTRE -> new CenteredTextContent(mutableText);
            default -> new TextContent((class_2561)mutableText);
        });
    }

    public void visit1(CodeLarkdownContent content) {
        StringBuilder sb = new StringBuilder();
        for (String line : content.lines()) {
            sb.append(line);
            sb.append('\n');
        }
        this.contents.add(new CodeContent(class_2561.method_30163((String)sb.toString()).method_27661()));
    }

    public void visit1(ImageLarkdownContent content) {
        class_2960 id = class_2960.method_12829((String)content.path());
        ImageContent imageContent = new ImageContent(content.width(), content.height(), content.scale(), id);
        this.contents.add(imageContent);
    }

    public Article makeArticle() {
        return new Article.Simple(this.contents);
    }

    @Override
    public void visit(LarkdownContent content) {
        this.delegate.visit(content);
    }
}

