/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.guide;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.neep.meatlib.larkdown.LarkdownContent;
import com.neep.meatlib.larkdown.LarkdownParseException;
import com.neep.meatlib.larkdown.LarkdownParser;
import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.guide.GuideLarkdownVisitor;
import com.neep.neepmeat.guide.GuideNode;
import com.neep.neepmeat.guide.GuideReloadEvent;
import com.neep.neepmeat.guide.article.Article;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GuideReloadListener
implements SimpleSynchronousResourceReloadListener {
    private static final GuideReloadListener INSTANCE = new GuideReloadListener();
    private final Map<String, Article> articles = new HashMap<String, Article>();
    private final Map<String, GuideNode.ArticleNode> articleNodes = new HashMap<String, GuideNode.ArticleNode>();
    @Nullable
    private GuideNode root;
    private final Deque<GuideNode> persistentPath = new LinkedList<GuideNode>();
    @Nullable
    private Article persistentArticle;

    public static GuideReloadListener getInstance() {
        return INSTANCE;
    }

    public class_2960 getFabricId() {
        return new class_2960("neepmeat", "guide");
    }

    public boolean isValid() {
        return this.getRootNode() != null;
    }

    private Predicate<class_2960> pathPredicate(String language) {
        return id -> {
            String path = id.method_12832();
            if (path.endsWith(language + ".json")) {
                return true;
            }
            if (path.endsWith(".md")) {
                return path.contains(language + "/");
            }
            return false;
        };
    }

    public void method_14491(class_3300 manager) {
        InputStream stream;
        this.root = null;
        this.articleNodes.clear();
        this.articles.clear();
        this.persistentPath.clear();
        this.persistentArticle = null;
        String language = class_310.method_1551().method_1526().method_4669();
        String defaultLanguage = "en_us";
        Map foundIds = manager.method_14488("guide", this.pathPredicate(language));
        if (foundIds.isEmpty()) {
            foundIds = manager.method_14488("guide", this.pathPredicate(defaultLanguage));
        }
        Map<Boolean, List<Map.Entry>> partitioned = foundIds.entrySet().stream().collect(Collectors.partitioningBy(entry -> !((class_2960)entry.getKey()).method_12832().endsWith("json")));
        List<Map.Entry> jsonFiles = partitioned.get(false);
        List<Map.Entry> markdownFiles = partitioned.get(true);
        for (Map.Entry entry2 : jsonFiles) {
            try {
                stream = ((class_3298)entry2.getValue()).method_14482();
                try {
                    InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                    JsonElement rootElement = JsonParser.parseReader((Reader)reader);
                    this.processArticles((JsonObject)rootElement);
                    if (!class_3518.method_34923((JsonObject)((JsonObject)rootElement), (String)"index")) continue;
                    if (this.root != null) {
                        throw new JsonParseException("Multiple index elements found");
                    }
                    this.root = this.processNode(class_3518.method_15296((JsonObject)((JsonObject)rootElement), (String)"index"));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NeepMeat.LOGGER.error("Error occurred while loading guide file {}", (Object)((class_2960)entry2.getKey()).toString(), (Object)e);
            }
        }
        for (Map.Entry entry2 : markdownFiles) {
            try {
                stream = ((class_3298)entry2.getValue()).method_14482();
                try {
                    LarkdownParser parser = new LarkdownParser(new InputStreamReader(stream, StandardCharsets.UTF_8));
                    List<LarkdownContent> contents = parser.getContents();
                    Map<String, String> preamble = parser.getPreamble();
                    String id = preamble.get("id");
                    if (id == null) {
                        throw new LarkdownParseException("No ID specified in preamble");
                    }
                    GuideNode.ArticleNode articleNode = this.articleNodes.get(id);
                    if (articleNode != null && preamble.containsKey("lookup")) {
                        for (String term : preamble.get("lookup").split(",")) {
                            term = term.strip();
                            articleNode.addLookupTerm(term);
                        }
                    }
                    Article article = new GuideLarkdownVisitor(contents).makeArticle();
                    this.articles.put(id, article);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (LarkdownParseException | IOException e) {
                NeepMeat.LOGGER.error("Error occurred while loading guide article {}", (Object)((class_2960)entry2.getKey()).toString(), (Object)e);
            }
        }
        if (this.root == null) {
            NeepMeat.LOGGER.error("Failed to load guide due to invalid JSON or missing index element");
        }
        ((GuideReloadEvent)GuideReloadEvent.POST.invoker()).apply(this);
    }

    protected void processArticles(JsonObject root) {
        JsonArray array = class_3518.method_15292((JsonObject)root, (String)"articles", (JsonArray)new JsonArray());
        array.forEach(e -> {
            String id = class_3518.method_15265((JsonObject)((JsonObject)e), (String)"id");
            Article article = Article.Simple.fromJson((JsonObject)e);
            this.articles.put(id, article);
        });
    }

    protected GuideNode processNode(JsonObject object) {
        String id = class_3518.method_15265((JsonObject)object, (String)"id");
        String icon = class_3518.method_15265((JsonObject)object, (String)"icon");
        String text = class_3518.method_15265((JsonObject)object, (String)"text");
        if (class_3518.method_15264((JsonObject)object, (String)"entries")) {
            ArrayList<GuideNode> nodes = new ArrayList<GuideNode>();
            class_3518.method_15261((JsonObject)object, (String)"entries").forEach(o -> nodes.add(this.processNode((JsonObject)o)));
            return new GuideNode.MenuNode(id, new class_2960(icon), class_2561.method_30163((String)text), nodes);
        }
        HashSet<String> lookup = new HashSet<String>();
        if (class_3518.method_15264((JsonObject)object, (String)"lookup")) {
            for (JsonElement term : class_3518.method_15261((JsonObject)object, (String)"lookup")) {
                lookup.add(term.getAsString());
            }
        } else if (class_3518.method_15289((JsonObject)object, (String)"lookup")) {
            lookup.add(class_3518.method_15265((JsonObject)object, (String)"lookup"));
        }
        GuideNode.ArticleNode node = new GuideNode.ArticleNode(id, lookup, new class_2960(icon), class_2561.method_30163((String)text));
        this.articleNodes.put(id, node);
        return node;
    }

    @Nullable
    public GuideNode getRootNode() {
        return this.root;
    }

    public Article getArticle(String id) {
        return this.articles.get(id);
    }

    @Nullable
    public List<GuideNode> getPath(class_1799 stack) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        GuideNode target = this.articleNodes.values().stream().filter(n -> n.matchesLookupTerm(itemId.toString())).findFirst().orElse(null);
        if (target != null) {
            ArrayList<GuideNode> route = new ArrayList<GuideNode>();
            this.recursiveDfs(this.root, target, route);
            route.add(target);
            return route;
        }
        return null;
    }

    @Nullable
    public List<GuideNode> getPath(String article) {
        GuideNode target = this.articleNodes.values().stream().filter(n -> n.getId().equals(article)).findFirst().orElse(null);
        if (target != null) {
            ArrayList<GuideNode> route = new ArrayList<GuideNode>();
            this.recursiveDfs(this.root, target, route);
            route.add(target);
            return route;
        }
        return null;
    }

    private boolean recursiveDfs(GuideNode node, GuideNode target, List<GuideNode> route) {
        route.add(route.size(), node);
        for (GuideNode child : node.getChildren()) {
            if (child == target) {
                return true;
            }
            boolean foundSub = this.recursiveDfs(child, target, route);
            if (!foundSub) continue;
            return true;
        }
        route.remove(route.size() - 1);
        return false;
    }

    public Collection<Article> getArticles() {
        return this.articles.values();
    }

    public Collection<GuideNode.ArticleNode> getArticleNodes() {
        return this.articleNodes.values();
    }

    public Deque<GuideNode> getPersistentPath() {
        return this.persistentPath;
    }

    @Nullable
    public Article getPersistentArticle() {
        return this.persistentArticle;
    }

    public void setPersistentArticle(@Nullable Article article) {
        this.persistentArticle = article;
    }

    public void insert(String name, Article article) {
        this.articles.put(name, article);
    }
}

