/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.grinder;

import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.client.renderer.BERenderUtils;
import com.neep.neepmeat.machine.grinder.GrinderBlock;
import com.neep.neepmeat.machine.grinder.GrinderBlockEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class GrinderRenderer
implements class_827<GrinderBlockEntity> {
    private final Random random = new Random();
    private final class_918 itemRenderer;

    public GrinderRenderer(class_5614.class_5615 ctx) {
        this.itemRenderer = ctx.method_43335();
    }

    public void render(GrinderBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        double sinTime = Math.sin(be.method_10997().method_8510()) * Math.cos(tickDelta) + Math.cos(be.method_10997().method_8510()) * Math.sin(tickDelta);
        class_2350 facing = (class_2350)be.method_11010().method_11654((class_2769)GrinderBlock.field_11177);
        matrices.method_22903();
        BERenderUtils.rotateFacing(facing, matrices);
        float yOffset = 0.6875f;
        if (be.currentRecipe != null && be.progressIncrement() > 0.0f) {
            yOffset = (float)((double)yOffset + Math.abs(sinTime * 0.02));
        }
        matrices.method_22903();
        matrices.method_22904(0.5, (double)yOffset, 0.5);
        WritableStackStorage input = be.getStorage().getInputStorage();
        class_1799 stack = input.getAsStack();
        int j = stack.method_7960() ? 187 : class_1792.method_7880((class_1792)stack.method_7909()) + stack.method_7919();
        this.random.setSeed(j);
        matrices.method_22907(class_7833.field_40714.rotationDegrees(-45.0f));
        matrices.method_22904(-0.5, -0.5, -0.5);
        BERenderUtils.rotateFacing(facing, matrices);
        matrices.method_22904(0.5, 0.5, 0.5);
        GrinderRenderer.renderItems(stack, matrices, vertexConsumers, this.itemRenderer, be.method_10997(), this.random, light);
        matrices.method_22909();
        matrices.method_22909();
    }

    public static void renderItems(class_1799 stack, class_4587 matrices, class_4597 vertices, class_918 itemRenderer, class_1937 world, Random random, int light) {
        matrices.method_22903();
        int k = GrinderRenderer.getRenderedAmount(stack);
        class_1087 bakedModel = itemRenderer.method_4019(stack, world, null, 0);
        boolean depth = bakedModel.method_4712();
        float sX = bakedModel.method_4709().field_4303.field_4285.x;
        float sY = bakedModel.method_4709().field_4303.field_4285.y;
        float sZ = bakedModel.method_4709().field_4303.field_4285.z;
        matrices.method_22907(class_7833.field_40716.rotationDegrees(1.0f));
        for (int u = 0; u < k; ++u) {
            matrices.method_22903();
            if (u > 0) {
                if (depth) {
                    s = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    t = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    float v = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                    matrices.method_46416(s, t, v);
                } else {
                    s = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    t = (random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                    matrices.method_22904((double)s, (double)t, 0.0);
                }
            }
            itemRenderer.method_23179(stack, class_811.field_4318, false, matrices, vertices, light, class_4608.field_21444, bakedModel);
            matrices.method_22909();
            if (depth) continue;
            matrices.method_46416(0.0f * sX, 0.0f * sY, 0.09375f * sZ);
        }
        matrices.method_22909();
    }

    public static int getRenderedAmount(class_1799 stack) {
        int i = 1;
        if (stack.method_7947() > 48) {
            i = 5;
        } else if (stack.method_7947() > 32) {
            i = 4;
        } else if (stack.method_7947() > 16) {
            i = 3;
        } else if (stack.method_7947() > 1) {
            i = 2;
        }
        return i;
    }
}

