/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.hydraulic_press;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.recipe.RecipeBehaviour;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.casting_basin.CastingBasinBlockEntity;
import com.neep.neepmeat.machine.casting_basin.CastingBasinStorage;
import com.neep.neepmeat.machine.hydraulic_press.MobSqueezeContext;
import com.neep.neepmeat.recipe.AbstractPressingRecipe;
import com.neep.neepmeat.recipe.MobSqueezingRecipe;
import com.neep.neepmeat.util.MiscUtil;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3612;
import net.minecraft.class_5575;
import org.jetbrains.annotations.Nullable;

public class HydraulicPressBlockEntity
extends SyncableBlockEntity {
    public static final long EXTEND_AMOUNT = 81000L;
    public static final int TICKS_EXTENDED = 30;
    protected boolean recipeControlled = true;
    protected short recipeState;
    protected int extensionTicks;
    @Nullable
    protected AbstractPressingRecipe<CastingBasinStorage> currentRecipe;
    protected SqueezingRecipeBehaviour behaviour = new SqueezingRecipeBehaviour();
    public float renderExtension;
    public WritableSingleFluidStorage fluidStorage = new WritableSingleFluidStorage(81000L, this::sync){

        protected boolean canInsert(FluidVariant variant) {
            return super.canInsert((TransferVariant)variant) && variant.isOf((Object)class_3612.field_15910) && (!HydraulicPressBlockEntity.this.recipeControlled || HydraulicPressBlockEntity.this.recipeState == 0 && HydraulicPressBlockEntity.this.hasRecipe());
        }

        protected boolean canExtract(FluidVariant variant) {
            return super.canExtract((TransferVariant)variant) && variant.isOf((Object)class_3612.field_15910) && (!HydraulicPressBlockEntity.this.recipeControlled || HydraulicPressBlockEntity.this.recipeState == 2);
        }
    };

    public HydraulicPressBlockEntity(class_2591<HydraulicPressBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public HydraulicPressBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.HYDRAULIC_PRESS, pos, state);
    }

    public void setState(int state) {
        this.recipeState = (short)state;
    }

    protected boolean hasRecipe() {
        return this.currentRecipe != null || this.behaviour.getCurrentRecipe() != null;
    }

    protected void startPressRecipe(CastingBasinStorage storage, AbstractPressingRecipe<CastingBasinStorage> recipe) {
        if (recipe == null || !storage.item(null).isEmpty()) {
            return;
        }
        storage.lock();
        this.currentRecipe = recipe;
        this.recipeState = 0;
    }

    protected void finishPressRecipe(CastingBasinStorage storage) {
        try (Transaction transaction = Transaction.openOuter();){
            boolean success = this.currentRecipe.takeInputs(storage, (TransactionContext)transaction);
            if (success) {
                transaction.commit();
            } else {
                transaction.abort();
            }
        }
    }

    protected void finishRecipe() {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10074());
        if (class_25862 instanceof CastingBasinBlockEntity) {
            CastingBasinBlockEntity basin = (CastingBasinBlockEntity)class_25862;
            this.finishPressRecipe(basin.getStorage());
        } else {
            this.behaviour.finishRecipe();
        }
    }

    protected void stopPressRecipe(@Nullable CastingBasinStorage storage) {
        if (storage != null) {
            storage.unlock();
        }
        this.recipeState = 0;
        this.currentRecipe = null;
    }

    protected void stopRecipe() {
        CastingBasinStorage castingBasinStorage;
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10074());
        if (class_25862 instanceof CastingBasinBlockEntity) {
            CastingBasinBlockEntity be = (CastingBasinBlockEntity)class_25862;
            castingBasinStorage = be.getStorage();
        } else {
            castingBasinStorage = null;
        }
        CastingBasinStorage storage = castingBasinStorage;
        this.stopPressRecipe(storage);
        this.behaviour.interrupt();
    }

    public void tick() {
        class_2586 class_25862 = this.field_11863.method_8321(this.field_11867.method_10074());
        if (class_25862 instanceof CastingBasinBlockEntity) {
            CastingBasinBlockEntity basin = (CastingBasinBlockEntity)class_25862;
            if (this.currentRecipe == null) {
                AbstractPressingRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.FAT_PRESSING, basin.getStorage()).orElse(null);
                if (recipe == null) {
                    recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.PRESSING, basin.getStorage()).orElse(null);
                }
                this.startPressRecipe(basin.getStorage(), recipe);
            }
        } else if (this.field_11863.method_22347(this.field_11867.method_10074()) && this.behaviour.getCurrentRecipe() == null) {
            class_238 box = class_238.method_19316((class_3341)new class_3341(this.field_11867.method_10074()));
            List entities = this.field_11863.method_18023(class_5575.method_31795(class_1297.class), box, e -> true);
            MobSqueezingRecipe squeezingRecipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.MOB_SQUEEZING, new MobSqueezeContext(this.field_11863, this.field_11867, entities)).orElse(null);
            this.behaviour.startRecipe(squeezingRecipe);
        }
        if (this.currentRecipe != null && !(this.field_11863.method_8321(this.field_11867.method_10074()) instanceof CastingBasinBlockEntity)) {
            this.stopRecipe();
            this.setState(2);
        }
        this.tickExtension();
    }

    private void tickExtension() {
        if (this.currentRecipe == null && this.behaviour.getCurrentRecipe() == null) {
            return;
        }
        if (this.recipeState == 0 && this.fluidStorage.getAmount() >= 81000L) {
            this.extensionTicks = 0;
            this.recipeState = 1;
        }
        if (this.recipeState == 1) {
            this.extensionTicks = Math.min(30, this.extensionTicks + 1);
            if (this.extensionTicks >= 30) {
                this.recipeState = (short)2;
                this.finishRecipe();
            }
        }
        if (this.recipeState == 2 && this.fluidStorage.getAmount() == 0L) {
            this.stopRecipe();
        }
    }

    public WritableSingleFluidStorage getStorage(class_2350 direction) {
        return this.fluidStorage;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.fluidStorage.toNbt(nbt);
        nbt.method_10575("recipeState", this.recipeState);
        nbt.method_10556("recipeControlled", this.recipeControlled);
        if (this.currentRecipe != null) {
            nbt.method_10582("currentRecipe", this.currentRecipe.method_8114().toString());
        }
        this.behaviour.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.fluidStorage.readNbt(nbt);
        this.recipeState = nbt.method_10568("recipeState");
        this.recipeControlled = nbt.method_10577("recipeControlled");
        this.currentRecipe = MiscUtil.ifPresentOrNull(nbt, "currentRecipe", s -> MeatlibRecipes.getInstance().get(class_2960.method_12829((String)s)).orElse(null));
        this.behaviour.readNbt(nbt);
    }

    public static Storage<FluidVariant> getFluidStorageFromTop(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 be, @Nullable class_2350 direction) {
        class_2586 class_25862 = world.method_8321(pos.method_10074());
        if (class_25862 instanceof HydraulicPressBlockEntity) {
            HydraulicPressBlockEntity press = (HydraulicPressBlockEntity)class_25862;
            return press.fluidStorage;
        }
        return null;
    }

    public class SqueezingRecipeBehaviour
    extends RecipeBehaviour<MobSqueezingRecipe>
    implements NbtSerialisable {
        @Override
        public void startRecipe(MobSqueezingRecipe recipe) {
            if (recipe == null) {
                return;
            }
            this.setRecipe(recipe);
            HydraulicPressBlockEntity.this.recipeState = 0;
        }

        @Override
        public void interrupt() {
            HydraulicPressBlockEntity.this.recipeState = 0;
            this.currentRecipe = null;
        }

        @Override
        public void finishRecipe() {
            if (this.currentRecipe != null) {
                try (Transaction transaction = Transaction.openOuter();){
                    class_238 box = class_238.method_19316((class_3341)new class_3341(HydraulicPressBlockEntity.this.field_11867.method_10074()));
                    List entities = HydraulicPressBlockEntity.this.field_11863.method_18023(class_5575.method_31795(class_1297.class), box, e -> true);
                    if (!entities.isEmpty()) {
                        ((MobSqueezingRecipe)this.currentRecipe).ejectOutputs(new MobSqueezeContext(HydraulicPressBlockEntity.this.field_11863, HydraulicPressBlockEntity.this.field_11867, entities), (TransactionContext)transaction);
                    }
                    transaction.commit();
                }
            }
        }
    }

    public static enum Mode {
        PRESSING,
        FAT_PRESSING,
        SQUEEZING;

    }
}

