/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.block.entity;

import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineComponent;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import com.neep.neepmeat.machine.live_machine.component.FluidInputComponent;
import com.neep.neepmeat.machine.live_machine.process.BioreactorProcess;
import com.neep.neepmeat.recipe.BioreactorRecipe;
import com.neep.neepmeat.util.MiscUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class StomachBlockEntity
extends class_2586
implements FluidInputComponent {
    private final InputSlot slot = new InputSlot();
    private final WritableSingleFluidStorage fluidInputStorage = new WritableSingleFluidStorage(5184000L, () -> ((StomachBlockEntity)this).method_5431());

    public StomachBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public boolean componentRemoved() {
        return this.method_11015();
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.slot.readNbt(nbt);
        this.fluidInputStorage.readNbt(nbt.method_10562("fluid_input"));
    }

    protected void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.slot.writeNbt(nbt);
        nbt.method_10566("fluid_input", (class_2520)this.fluidInputStorage.toNbt(new class_2487()));
    }

    @Override
    public ComponentType<? extends LivingMachineComponent> getComponentType() {
        return LivingMachineComponents.STOMACH;
    }

    public InputSlot getSlot() {
        return this.slot;
    }

    public WritableSingleFluidStorage getStorage(class_2350 ctx) {
        return this.fluidInputStorage;
    }

    public static class InputSlot
    implements NbtSerialisable {
        private float counter;
        @Nullable
        private BioreactorRecipe recipe;

        public void tickRecipe(float progressIncrement, BioreactorProcess.Context context) {
            if (this.recipe == null) {
                this.recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.BIOREACTOR, context).orElse(null);
                if (this.recipe != null) {
                    this.counter = this.recipe.getProcessTime();
                }
            }
            if (this.recipe != null) {
                if (this.counter > 0.0f) {
                    this.counter = Math.max(0.0f, this.counter - progressIncrement);
                } else {
                    try (Transaction transaction = Transaction.openOuter();){
                        if (this.recipe.takeInputs(context, (TransactionContext)transaction) && this.recipe.ejectOutputs(context, (TransactionContext)transaction)) {
                            transaction.commit();
                        } else {
                            transaction.abort();
                        }
                        this.recipe = null;
                    }
                }
            }
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            this.recipe = MiscUtil.ifPresentOrNull(nbt, "recipe", s -> MeatlibRecipes.getInstance().get(class_2960.method_12829((String)s)).orElse(null));
            return nbt;
        }

        @Override
        public void readNbt(class_2487 nbt) {
            if (this.recipe != null) {
                nbt.method_10582("recipe", this.recipe.method_8114().toString());
            }
        }
    }
}

