/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.live_machine.process;

import com.neep.neepmeat.NeepMeat;
import com.neep.neepmeat.api.live_machine.ComponentType;
import com.neep.neepmeat.api.live_machine.LivingMachineBlockEntity;
import com.neep.neepmeat.api.live_machine.Process;
import com.neep.neepmeat.machine.charnel_pump.CharnelPumpBlockEntity;
import com.neep.neepmeat.machine.live_machine.LivingMachineComponents;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_2561;

public class CharnelPumpProcess
implements Process {
    private static final List<ComponentType<?>> REQUIRED = List.of(LivingMachineComponents.CHARNEL_PUMP, LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.FLUID_INPUT);

    @Override
    public void serverTick(LivingMachineBlockEntity be) {
        be.withComponents(LivingMachineComponents.CHARNEL_PUMP, LivingMachineComponents.MOTOR_PORT, LivingMachineComponents.FLUID_INPUT).ifPresent(with -> {
            CharnelPumpBlockEntity pump = (CharnelPumpBlockEntity)with.t1().iterator().next();
            try (Transaction transaction = Transaction.openOuter();){
                Storage<FluidVariant> inputStorage = be.getCombinedFluidInput();
                pump.serverTick(be.getPower(), inputStorage, transaction);
                transaction.commit();
            }
        });
    }

    @Override
    public List<ComponentType<?>> getRequired() {
        return REQUIRED;
    }

    @Override
    public class_2561 getName() {
        return NeepMeat.translationKey("process", "charnel_pump");
    }
}

