/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.pedestal;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.recipe.ImplementedRecipe;
import com.neep.meatlib.recipe.MeatlibRecipes;
import com.neep.meatlib.util.NbtSerialisable;
import com.neep.meatweapons.particle.MWGraphicsEffects;
import com.neep.meatweapons.particle.MWParticles;
import com.neep.neepmeat.api.storage.WritableStackStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMrecipeTypes;
import com.neep.neepmeat.machine.integrator.Integrator;
import com.neep.neepmeat.plc.component.MutateInPlace;
import com.neep.neepmeat.recipe.EnlighteningRecipe;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PedestalBlockEntity
extends SyncableBlockEntity {
    protected WritableStackStorage storage;
    protected final RecipeBehaviour recipeBehaviour;
    protected boolean powered;
    public static final int MAX_COOLDOWN = 10;
    protected int cooldown;
    private final MIP mip = new MIP();

    public PedestalBlockEntity(class_2591<?> type, final class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.recipeBehaviour = new RecipeBehaviour();
        this.storage = new WritableStackStorage(this::sync, 1){

            @Override
            protected void onFinalCommit() {
                super.onFinalCommit();
                PedestalBlockEntity.this.field_11863.method_8455(pos, PedestalBlockEntity.this.method_11010().method_26204());
            }
        };
    }

    public PedestalBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.PEDESTAL, pos, state);
    }

    public void update(boolean redstone) {
        this.powered = redstone;
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        nbt.method_10569("cooldown", this.cooldown);
        this.recipeBehaviour.writeNbt(nbt);
        this.storage.writeNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.cooldown = nbt.method_10550("cooldown");
        this.recipeBehaviour.readNbt(nbt);
        this.storage.readNbt(nbt);
    }

    public void spawnParticles(int count, double dy, double speed) {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            serverWorld.method_14199((class_2394)MWParticles.PLASMA_PARTICLE, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5 - 2.0, (double)this.field_11867.method_10260() + 0.5, count, 0.0, dy, 0.0, 0.1);
        }
    }

    public static void spawnBeam(class_3218 world, class_2338 startPos, class_2338 endPos) {
        class_243 start = class_243.method_26410((class_2382)startPos, (double)0.9);
        class_243 end = class_243.method_26410((class_2382)endPos, (double)0.8f);
        for (class_3222 player : PlayerLookup.around((class_3218)world, (class_243)start, (double)32.0)) {
            MWGraphicsEffects.syncBeamEffect(player, MWGraphicsEffects.BEAM, (class_1937)world, start, end, new class_243(0.0, 0.0, 0.0), 0.5f, 50);
        }
    }

    public WritableStackStorage getStorage(@Nullable class_2350 dir) {
        return this.storage;
    }

    public void tick() {
        this.cooldown = Math.max(0, this.cooldown - 1);
        if (this.cooldown == 0) {
            this.cooldown = 10;
            this.recipeBehaviour.update();
        }
    }

    public void extractFromItem(class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (itemStack.method_7960()) {
            return;
        }
        try (Transaction transaction = Transaction.openOuter();){
            int transferred = (int)this.storage.insert((TransferVariant)ItemVariant.of((class_1799)itemStack), itemStack.method_7947(), (TransactionContext)transaction);
            itemStack.method_7934(transferred);
            if (itemStack.method_7947() <= 0) {
                itemEntity.method_31472();
            }
            transaction.commit();
        }
    }

    public MutateInPlace<class_1799> getMutateInPlace(Void unused) {
        return this.mip;
    }

    public class MIP
    implements MutateInPlace<class_1799> {
        @Override
        public class_1799 get() {
            return PedestalBlockEntity.this.storage.getAsStack();
        }

        @Override
        public void set(class_1799 stack) {
            PedestalBlockEntity.this.storage.setStack(stack);
        }
    }

    public class RecipeBehaviour
    extends com.neep.meatlib.recipe.RecipeBehaviour<EnlighteningRecipe>
    implements ImplementedRecipe.DummyInventory,
    NbtSerialisable {
        protected class_2338 integrator = class_2338.field_10980;

        public WritableStackStorage getStorage() {
            return PedestalBlockEntity.this.storage;
        }

        @Override
        public void startRecipe(EnlighteningRecipe recipe) {
            this.setRecipe(recipe);
            this.getIntegrator().setLookPos(PedestalBlockEntity.this.field_11867);
            PedestalBlockEntity.this.field_11863.method_39279(PedestalBlockEntity.this.field_11867, PedestalBlockEntity.this.method_11010().method_26204(), 50);
            this.getIntegrator().spawnBeam(PedestalBlockEntity.this.field_11863, PedestalBlockEntity.this.field_11867);
            PedestalBlockEntity.this.sync();
        }

        @Override
        public void interrupt() {
            this.setRecipe(null);
        }

        @Override
        public void finishRecipe() {
            try (Transaction transaction = Transaction.openOuter();){
                if (this.currentRecipe != null) {
                    ((EnlighteningRecipe)this.currentRecipe).ejectOutputs(this, (TransactionContext)transaction);
                }
                transaction.commit();
            }
            this.setRecipe(null);
            PedestalBlockEntity.this.sync();
        }

        public void update() {
            if (this.currentRecipe == null && !PedestalBlockEntity.this.storage.isEmpty()) {
                Integrator integrator = Integrator.findIntegrator(PedestalBlockEntity.this.field_11863, PedestalBlockEntity.this.field_11867, 10);
                if (integrator == null || !integrator.canEnlighten()) {
                    return;
                }
                this.integrator = integrator.getBlockPos();
                EnlighteningRecipe recipe = MeatlibRecipes.getInstance().getFirstMatch(NMrecipeTypes.ENLIGHTENING, this).orElse(null);
                if (recipe != null) {
                    this.startRecipe(recipe);
                }
            }
            PedestalBlockEntity.this.sync();
        }

        @Override
        public class_2487 writeNbt(class_2487 nbt) {
            super.writeNbt(nbt);
            nbt.method_10566("integrator", (class_2520)class_2512.method_10692((class_2338)this.integrator));
            return nbt;
        }

        @Override
        public void readNbt(class_2487 tag) {
            super.readNbt(tag);
            this.integrator = class_2512.method_10691((class_2487)tag.method_10562("integrator"));
        }

        public Integrator getIntegrator() {
            class_2586 class_25862 = PedestalBlockEntity.this.field_11863.method_8321(this.integrator);
            if (class_25862 instanceof Integrator) {
                Integrator be = (Integrator)class_25862;
                return be;
            }
            return null;
        }
    }
}

