/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.machine.transducer;

import com.neep.meatlib.blockentity.SyncableBlockEntity;
import com.neep.meatlib.util.LazySupplier;
import com.neep.neepmeat.api.Burner;
import com.neep.neepmeat.api.FluidPump;
import com.neep.neepmeat.api.processing.PowerUtils;
import com.neep.neepmeat.api.storage.WritableSingleFluidStorage;
import com.neep.neepmeat.init.NMBlockEntities;
import com.neep.neepmeat.init.NMFluids;
import com.neep.neepmeat.transport.api.AutoEjector;
import com.neep.neepmeat.transport.fluid_network.node.AcceptorModes;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleVariantStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public class TransducerBlockEntity
extends SyncableBlockEntity {
    public static final FluidVariant INPUT_VARIANT = FluidVariant.of((class_3611)class_3612.field_15910);
    protected WritableSingleFluidStorage storage = new WritableSingleFluidStorage(81000L, this::method_5431){

        public boolean supportsInsertion() {
            return false;
        }
    };
    protected LazySupplier<BlockApiCache<Burner, Void>> burnerCache = LazySupplier.of(() -> BlockApiCache.create(Burner.LOOKUP, (class_3218)((class_3218)this.method_10997()), (class_2338)this.field_11867.method_10087(2)));
    protected BlockApiCache<Storage<FluidVariant>, class_2350> inputCache;
    protected FluidPump pump = FluidPump.of(-0.5f, () -> AcceptorModes.PUSH);
    protected long outputPower;
    protected boolean needsUpdate = true;
    private final AutoEjector<FluidVariant> ejector = this.addListener(AutoEjector.simpleFluid(() -> class_2350.field_11036, this, (Storage<FluidVariant>)this.storage, this.pump));

    public TransducerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public TransducerBlockEntity(class_2338 pos, class_2680 state) {
        this(NMBlockEntities.TRANSDUCER, pos, state);
    }

    public SingleVariantStorage<FluidVariant> getStorage(class_2350 ignored) {
        return this.storage;
    }

    public FluidPump getPump(class_2350 ignored) {
        return this.pump;
    }

    public void updateBurners() {
        this.inputCache = BlockApiCache.create((BlockApiLookup)FluidStorage.SIDED, (class_3218)((class_3218)this.field_11863), (class_2338)this.field_11867.method_10074());
        this.needsUpdate = false;
    }

    public void tick() {
        if (this.needsUpdate) {
            this.updateBurners();
        }
        this.outputPower = 0L;
        Burner burner = (Burner)this.burnerCache.get().find(null);
        if (burner != null) {
            burner.tickPowerConsumption();
            this.outputPower += (long)burner.getOutputPower();
        } else {
            this.updateBurners();
        }
        Storage inputStorage = (Storage)this.inputCache.find((Object)class_2350.field_11036);
        if (inputStorage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long produceAmount = PowerUtils.absToAmount((class_3611)NMFluids.STILL_ETHEREAL_FUEL, this.outputPower);
                long extracted = inputStorage.extract((Object)INPUT_VARIANT, produceAmount, (TransactionContext)transaction);
                long inserted = this.storage.insert(FluidVariant.of((class_3611)NMFluids.STILL_ETHEREAL_FUEL), Math.min(produceAmount, extracted), (TransactionContext)transaction);
                if (inserted == produceAmount) {
                    transaction.commit();
                } else {
                    transaction.abort();
                }
            }
        }
        this.ejector.tick(null);
    }

    public void update() {
        this.needsUpdate = true;
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, TransducerBlockEntity be) {
        be.tick();
    }

    @Override
    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        this.storage.toNbt(nbt);
    }

    @Override
    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.storage.readNbt(nbt);
    }
}

