/*
 * Decompiled with CFR 0.152.
 */
package com.neep.neepmeat.neepasm.compiler;

import com.google.common.collect.Lists;
import com.neep.meatlib.util.NeepAsmTokenView;
import com.neep.meatlib.util.StringTokenView;
import com.neep.neepmeat.neepasm.NeepASM;
import com.neep.neepmeat.neepasm.compiler.InstructionAcceptor;
import com.neep.neepmeat.neepasm.compiler.ParsedFunction;
import com.neep.neepmeat.neepasm.compiler.ParsedSource;
import com.neep.neepmeat.neepasm.compiler.alias.ParsedAlias;
import com.neep.neepmeat.neepasm.compiler.alias.ParsedArgumentAlias;
import com.neep.neepmeat.neepasm.compiler.parser.InstructionParser;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedFunctionCallInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedInstruction;
import com.neep.neepmeat.neepasm.compiler.parser.ParsedMacro;
import com.neep.neepmeat.neepasm.program.KeyValue;
import com.neep.neepmeat.neepasm.program.Label;
import com.neep.neepmeat.plc.instruction.Argument;
import com.neep.neepmeat.plc.instruction.Instruction;
import com.neep.neepmeat.plc.instruction.InstructionProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;

public class NeepAsmParser {
    private final Map<String, InstructionProvider> instructionMap;
    private ParsedSource parsedSource = new ParsedSource();
    private int line = 0;

    public NeepAsmParser(Map<String, InstructionProvider> instructionMap) {
        this.instructionMap = instructionMap;
    }

    public static boolean isSimplePattern(String identifier) {
        return identifier.matches("^[a-zA-Z0-9_:]+$");
    }

    public static String convertToRegex(String notGlob) {
        return notGlob.replace("*", ".*");
    }

    public ParsedSource parse(String source) throws NeepASM.ProgramBuildException {
        this.parsedSource = new ParsedSource();
        NeepAsmTokenView view = new NeepAsmTokenView(source);
        try {
            this.line = 0;
            while (!view.eof()) {
                this.parseLine(view);
                view.nextLine();
                ++this.line;
            }
            this.parsedSource.instruction((s, program) -> Instruction.EMPTY, -1);
            for (ParsedFunction func : this.parsedSource.functions()) {
                func.expand(this.parsedSource);
            }
        }
        catch (NeepASM.ParseException e) {
            throw new NeepASM.ProgramBuildException(view.line(), view.linePos(), e.getMessage());
        }
        return this.parsedSource;
    }

    public void parseInstructionOrMacro(InstructionAcceptor parsedSource, NeepAsmTokenView view, String prevToken, @Nullable String scope) throws NeepASM.ParseException {
        ParsedMacro macro = parsedSource.findMacro(prevToken);
        if (macro != null) {
            macro.expand(view, parsedSource, this, new HashSet<ParsedMacro>());
        } else {
            ParsedInstruction instruction = this.parseInstruction(view, scope);
            if (instruction != null) {
                parsedSource.instruction(instruction, view.line());
            }
        }
    }

    public void parseLine(NeepAsmTokenView view) throws NeepASM.ParseException {
        String token;
        if (view.peekThing() == '%') {
            String id;
            view.next();
            switch (id = view.nextIdentifier()) {
                case "func": {
                    this.parseFunction(view);
                    return;
                }
                case "macro": {
                    this.parseMacro(view);
                    return;
                }
                case "alias": {
                    this.parseAlias(view);
                    return;
                }
            }
            throw new NeepASM.ParseException("unexpected directive '" + id + "'");
        }
        try (StringTokenView.Mark entry = view.mark();){
            token = view.nextIdentifier();
            char follow = view.nextThing();
            if (follow == ':') {
                this.parsedSource.label(new Label(token, this.parsedSource.size()));
                this.assureLineEnd(view);
                entry.commit();
            }
        }
        this.parseInstructionOrMacro(this.parsedSource, view, token, null);
    }

    private void parseMacro(NeepAsmTokenView view) throws NeepASM.ParseException {
        StringBuilder macroText = new StringBuilder();
        String name = view.nextIdentifier();
        if (name.isEmpty()) {
            throw new NeepASM.ParseException("expected macro name");
        }
        int startLine = view.line();
        ArrayList parameters = Lists.newArrayList();
        view.fastForward();
        while (view.isIdentifier(0, view.peek())) {
            parameters.add(this.parseMacroParameter(view));
            view.fastForward();
        }
        if (!view.lineEnded() && !NeepAsmParser.isComment(view)) {
            throw new NeepASM.ParseException("unexpected token");
        }
        while (!view.eof()) {
            if (view.peek() == '%') {
                try (StringTokenView.Mark entry = view.mark();){
                    view.next();
                    String id = view.nextIdentifier();
                    if (id.equals("end")) {
                        entry.commit();
                        this.parsedSource.macro(new ParsedMacro(name, parameters, macroText.toString(), startLine));
                        return;
                    }
                }
            }
            macroText.append(view.peek());
            view.next();
        }
        throw new NeepASM.ParseException("reached end of file while parsing macro '" + name + "'");
    }

    private String parseMacroParameter(NeepAsmTokenView view) {
        view.fastForward();
        return view.nextIdentifier();
    }

    private void parseAlias(NeepAsmTokenView view) throws NeepASM.ParseException {
        String name = view.nextIdentifier();
        if (name.isEmpty()) {
            throw new NeepASM.ParseException("expected value after alias");
        }
        if (view.nextThing() != '=') {
            throw new NeepASM.ParseException("expected = after alias name");
        }
        Argument argument = this.parseWorldTarget(view);
        if (argument != null) {
            this.parsedSource.alias(new ParsedArgumentAlias(name, argument));
            return;
        }
        throw new NeepASM.ParseException("invalid value for alias '" + name + "'");
    }

    private void parseFunction(NeepAsmTokenView view) throws NeepASM.ParseException {
        String name = view.nextIdentifier();
        if (name.isEmpty()) {
            throw new NeepASM.ParseException("expected function name");
        }
        if (!view.lineEnded() && !NeepAsmParser.isComment(view)) {
            throw new NeepASM.ParseException("unexpected token");
        }
        view.nextLine();
        ParsedFunction function = new ParsedFunction(name, this.parsedSource::findMacro);
        view.fastForward();
        while (view.peekThing() != '%') {
            this.parseFunctionLine(function, view);
            view.nextLine();
            if (!view.eof()) continue;
            throw new NeepASM.ParseException("reached end of file while parsing function '" + name + "'");
        }
        view.next();
        if (!view.nextIdentifier().equals("end")) {
            throw new NeepASM.ParseException("in '" + name + "': directives not allowed in function");
        }
        this.parsedSource.function(function);
    }

    private void parseFunctionLine(ParsedFunction function, NeepAsmTokenView view) throws NeepASM.ParseException {
        String token;
        try (StringTokenView.Mark entry = view.mark();){
            token = view.nextIdentifier();
            char follow = view.nextThing();
            if (follow == ':') {
                function.label(function.mangleLabel(token, function.size()));
                this.assureLineEnd(view);
                entry.commit();
                return;
            }
        }
        this.parseInstructionOrMacro(function, view, token, function.name());
    }

    @Nullable
    public ParsedInstruction parseInstruction(NeepAsmTokenView view, @Nullable String scope) throws NeepASM.ParseException {
        view.fastForward();
        if (view.lineEnded() || NeepAsmParser.isComment(view)) {
            return null;
        }
        String id = view.nextIdentifier();
        InstructionProvider provider = this.readInstruction(id);
        if (provider != null) {
            InstructionParser parser = provider.getParser();
            return parser.parse(view, this, scope);
        }
        ParsedFunction function = this.parsedSource.findFunction(id);
        if (function != null) {
            return new ParsedFunctionCallInstruction(id, view);
        }
        throw new NeepASM.ParseException("unrecognised operation '" + id + "'");
    }

    @Nullable
    private InstructionProvider readInstruction(String id) {
        return this.instructionMap.get(id.toLowerCase());
    }

    @Nullable
    public Argument parseWorldTarget(NeepAsmTokenView view) throws NeepASM.ParseException {
        try (StringTokenView.Mark entry = view.mark();){
            if (view.peekThing() == '$') {
                view.next();
                entry.commit();
                String name = view.nextIdentifier();
                if (name.isEmpty()) {
                    throw new NeepASM.ParseException("expected alias name");
                }
                ParsedAlias alias = this.parsedSource.findAlias(name);
                if (alias == null) {
                    throw new NeepASM.ParseException("alias '" + name + "' not found");
                }
                Argument argument = ((ParsedArgumentAlias)alias).argument();
                return argument;
            }
            if (view.peekThing() == '@') {
                view.next();
                entry.commit();
                if (view.nextThing() == '(') {
                    class_2350 direction = class_2350.field_11036;
                    if (this.isDigit(view.peekThing())) {
                        int x = view.nextInteger();
                        if (this.isDigit(view.peekThing())) {
                            int y = view.nextInteger();
                            if (this.isDigit(view.peekThing())) {
                                int z = view.nextInteger();
                                if (Character.isAlphabetic(view.peekThing()) && (direction = NeepAsmParser.parseDirection(view)) == null) {
                                    direction = class_2350.field_11036;
                                }
                                if (view.nextThing() == ')') {
                                    Argument argument = new Argument(new class_2338(x, y, z), direction);
                                    return argument;
                                }
                            }
                        }
                    }
                }
                throw new NeepASM.ParseException("malformed target\n Targets should be of the form '@(<x> <y> <z> <direction>)");
            }
        }
        return null;
    }

    @Nullable
    public static class_2350 parseDirection(StringTokenView view) throws NeepASM.ParseException {
        String name = view.nextIdentifier();
        return NeepAsmParser.parseDirection(name);
    }

    @Nullable
    public static class_2350 parseDirection(String name) throws NeepASM.ParseException {
        if (!name.isEmpty()) {
            class_2350 direction = NeepAsmParser.directionByName(name);
            if (direction == null) {
                throw new NeepASM.ParseException("no such direction '" + name + "'\n Directions are specified with the full name or first letter (north or n)");
            }
            return direction;
        }
        return null;
    }

    @Nullable
    public static class_2350 directionByName(String name) {
        class_2350 d = class_2350.method_10168((String)(name = name.toLowerCase()));
        if (d == null) {
            d = switch (name) {
                case "n" -> class_2350.field_11043;
                case "e" -> class_2350.field_11034;
                case "s" -> class_2350.field_11035;
                case "w" -> class_2350.field_11039;
                case "u" -> class_2350.field_11036;
                case "d" -> class_2350.field_11033;
                default -> null;
            };
        }
        return d;
    }

    @Nullable
    public KeyValue parseKV(NeepAsmTokenView view) throws NeepASM.ParseException {
        try (StringTokenView.Mark entry = view.mark();){
            String key = view.nextIdentifier();
            if (!key.isEmpty()) {
                String val;
                if (view.nextThing() == '=' && !(val = view.nextIdentifier()).isEmpty()) {
                    entry.commit();
                    KeyValue keyValue = new KeyValue(key, val);
                    return keyValue;
                }
                throw new NeepASM.ParseException("malformed key-value pair");
            }
        }
        return null;
    }

    public void assureLineEnd(NeepAsmTokenView view) throws NeepASM.ParseException {
        view.fastForward();
        boolean b1 = NeepAsmParser.isComment(view);
        boolean b2 = view.lineEnded();
        if (!NeepAsmParser.isComment(view) && !view.lineEnded()) {
            throw new NeepASM.ParseException("unexpected token '" + view.nextBlob() + "'");
        }
    }

    private boolean isDigit(char c) {
        return c == '-' || Character.isDigit(c);
    }

    public static boolean isComment(StringTokenView view) {
        try (StringTokenView.Mark ignored = view.mark();){
            boolean bl = view.nextThing() == '#';
            return bl;
        }
    }

    public ParsedSource getParsedSource() {
        return this.parsedSource;
    }
}

